/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.configuration;

import io.hops.hadoop.shaded.org.mockito.Captor;
import io.hops.hadoop.shaded.org.mockito.InjectMocks;
import io.hops.hadoop.shaded.org.mockito.Mock;
import io.hops.hadoop.shaded.org.mockito.MockitoAnnotations;
import io.hops.hadoop.shaded.org.mockito.Spy;
import io.hops.hadoop.shaded.org.mockito.configuration.AnnotationEngine;
import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import io.hops.hadoop.shaded.org.mockito.internal.configuration.DefaultAnnotationEngine;
import io.hops.hadoop.shaded.org.mockito.internal.configuration.DefaultInjectionEngine;
import io.hops.hadoop.shaded.org.mockito.internal.configuration.SpyAnnotationEngine;
import io.hops.hadoop.shaded.org.mockito.internal.util.reflection.FieldReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectingAnnotationEngine
implements AnnotationEngine {
    AnnotationEngine delegate = new DefaultAnnotationEngine();
    AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    @Override
    public void process(Class<?> context, Object testClass) {
        Field[] fields;
        this.delegate.process(context, testClass);
        this.spyAnnotationEngine.process(context, testClass);
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoAnnotations(field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            this.injectMocks(testClass);
        }
    }

    void assertNoAnnotations(Field field, Class ... annotations) {
        for (Class annotation : annotations) {
            if (!field.isAnnotationPresent(annotation)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), InjectMocks.class.getSimpleName());
        }
    }

    public void injectMocks(Object testClass) {
        HashSet<Field> mockDependents = new HashSet<Field>();
        HashSet<Object> mocks = new HashSet<Object>();
        for (Class<?> clazz = testClass.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            mockDependents.addAll(InjectingAnnotationEngine.scanForInjection(testClass, clazz));
            mocks.addAll(InjectingAnnotationEngine.scanMocks(testClass, clazz));
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependents, mocks, testClass);
    }

    private static Set<Field> scanForInjection(Object testClass, Class<?> clazz) {
        Field[] fields;
        HashSet<Field> testedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectMocks.class)) continue;
            if (new FieldReader(testClass, field).isNull()) {
                new Reporter().injectMockAnnotationFieldIsNull(field.getName());
            }
            testedFields.add(field);
        }
        return testedFields;
    }

    private static Set<Object> scanMocks(Object testClass, Class<?> clazz) {
        HashSet<Object> mocks = new HashSet<Object>();
        for (Field field : clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(Spy.class) && null == field.getAnnotation(Mock.class) && null == field.getAnnotation(Mock.class)) continue;
            Object fieldInstance = null;
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                fieldInstance = field.get(testClass);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems injecting dependencies in " + field.getName(), e);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
            if (fieldInstance == null) continue;
            mocks.add(fieldInstance);
        }
        return mocks;
    }
}

