/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.serialization.coders;

import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.BasicBytez;
import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.onheap.HeapBytez;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzNameRegistry;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import io.hops.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTBufferTooSmallException;
import io.hops.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;
import java.io.IOException;
import java.io.OutputStream;

public class FSTBytezEncoder
implements FSTEncoder {
    private FSTConfiguration conf;
    private FSTClazzNameRegistry clnames;
    private BasicBytez buffout;
    private long pos;
    private byte[] ascStringCache;
    OutputStream outStream;
    boolean autoResize = true;
    char[] chBufS;

    public FSTBytezEncoder(FSTConfiguration conf, BasicBytez base) {
        if (FSTConfiguration.isAndroid) {
            throw new RuntimeException("not supported on android");
        }
        this.conf = conf;
        this.buffout = base;
        this.clnames = (FSTClazzNameRegistry)conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(conf.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    void writeFBooleanArr(boolean[] arr, int off, int len) throws IOException {
        this.ensureFree(len);
        this.buffout.setBoolean(this.pos, arr, off, len);
        this.pos += (long)len;
    }

    public void writeFFloatArr(float[] arr, int off, int len) throws IOException {
        this.ensureFree(4 * len);
        this.buffout.setFloat(this.pos, arr, off, len);
        this.pos += (long)(4 * len);
    }

    public void writeFDoubleArr(double[] arr, int off, int len) throws IOException {
        this.ensureFree(8 * len);
        this.buffout.setDouble(this.pos, arr, off, len);
        this.pos += (long)(8 * len);
    }

    public void writeFShortArr(short[] arr, int off, int len) throws IOException {
        this.ensureFree(2 * len);
        this.buffout.setShort(this.pos, arr, off, len);
        this.pos += (long)(2 * len);
    }

    public void writeFCharArr(char[] arr, int off, int len) throws IOException {
        this.ensureFree(2 * len);
        this.buffout.setChar(this.pos, arr, off, len);
        this.pos += (long)(2 * len);
    }

    void writeFIntArr(int[] arr, int off, int len) throws IOException {
        this.ensureFree(4 * len);
        this.buffout.setInt(this.pos, arr, off, len);
        this.pos += (long)(4 * len);
    }

    void writeFLongArr(long[] arr, int off, int len) throws IOException {
        this.ensureFree(8 * len);
        this.buffout.setLong(this.pos, arr, off, len);
        this.pos += (long)(8 * len);
    }

    @Override
    public void writePrimitiveArray(Object array, int off, int len) throws IOException {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Byte.TYPE) {
            this.writeRawBytes((byte[])array, off, len);
        } else if (componentType == Character.TYPE) {
            this.writeFCharArr((char[])array, off, len);
        } else if (componentType == Short.TYPE) {
            this.writeFShortArr((short[])array, off, len);
        } else if (componentType == Integer.TYPE) {
            this.writeFIntArr((int[])array, off, len);
        } else if (componentType == Double.TYPE) {
            this.writeFDoubleArr((double[])array, off, len);
        } else if (componentType == Float.TYPE) {
            this.writeFFloatArr((float[])array, off, len);
        } else if (componentType == Long.TYPE) {
            this.writeFLongArr((long[])array, off, len);
        } else if (componentType == Boolean.TYPE) {
            this.writeFBooleanArr((boolean[])array, off, len);
        } else {
            throw new RuntimeException("expected primitive array");
        }
    }

    @Override
    public void writeRawBytes(byte[] array, int start, int length) throws IOException {
        this.ensureFree((int)(this.pos + (long)length));
        this.buffout.set(this.pos, array, start, length);
        this.pos += (long)length;
    }

    char[] getCharBuf(int siz) {
        char[] chars = this.chBufS;
        if (chars == null || chars.length < siz) {
            this.chBufS = chars = new char[Math.max(siz, 15)];
        }
        return chars;
    }

    @Override
    public void writeStringUTF(String str) throws IOException {
        int strlen = str.length();
        this.writeFInt(strlen);
        this.ensureFree(strlen * 2);
        char[] c = this.getCharBuf(strlen);
        str.getChars(0, strlen, c, 0);
        this.buffout.setChar(this.pos, c, 0, strlen);
        this.pos += (long)(strlen * 2);
    }

    @Override
    public void writeFShort(short c) throws IOException {
        this.writePlainShort(c);
    }

    @Override
    public boolean writeAttributeName(FSTClazzInfo.FSTFieldInfo subInfo, Object value) {
        return false;
    }

    @Override
    public boolean writeTag(byte tag, Object info, long somValue, Object toWrite, FSTObjectOutput oout) throws IOException {
        this.writeFByte(tag);
        return false;
    }

    @Override
    public void writeFChar(char c) throws IOException {
        this.writePlainChar(c);
    }

    @Override
    public final void writeFByte(int v) throws IOException {
        this.ensureFree(1);
        this.buffout.put(this.pos++, (byte)v);
    }

    @Override
    public void writeFInt(int anInt) throws IOException {
        this.writePlainInt(anInt);
    }

    @Override
    public void writeFLong(long anInt) throws IOException {
        this.writePlainLong(anInt);
    }

    @Override
    public void writeFFloat(float value) throws IOException {
        this.writePlainInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeFDouble(double value) throws IOException {
        this.writePlainLong(Double.doubleToLongBits(value));
    }

    @Override
    public int getWritten() {
        return (int)this.pos;
    }

    @Override
    public void close() throws IOException {
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void reset(byte[] out) {
        this.pos = 0L;
        this.clnames.clear();
        if (out != null) {
            throw new RuntimeException("not implemented");
        }
    }

    @Override
    public void skip(int i) {
        this.pos += (long)i;
    }

    @Override
    public void writeInt32At(int position, int v) {
        try {
            this.ensureFree(position + 4);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        this.buffout.putInt(position, v);
    }

    @Override
    public void setOutstream(OutputStream outstream) {
        this.outStream = outstream;
    }

    @Override
    public void flush() throws IOException {
        if (this.outStream != null) {
            this.outStream.write(this.getBuffer(), 0, (int)this.pos);
        }
        this.pos = 0L;
    }

    @Override
    public void ensureFree(int bytes) throws IOException {
        if (this.buffout.length() <= this.pos + (long)bytes) {
            if (this.autoResize) {
                BasicBytez newbytez = this.buffout.newInstance(Math.max(this.pos + (long)bytes, Math.min(0x7FFFFFF5L, this.buffout.length() * 2L)));
                this.buffout.copyTo(newbytez, 0L, 0L, this.pos);
                this.buffout = newbytez;
            } else {
                throw FSTBufferTooSmallException.Instance;
            }
        }
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    @Override
    public byte[] getBuffer() {
        if (this.isPlainBAAccessible()) {
            return ((HeapBytez)this.buffout).asByteArray();
        }
        byte[] res = new byte[(int)this.pos];
        this.buffout.getArr(0L, res, 0, (int)this.pos);
        return res;
    }

    protected boolean isPlainBAAccessible() {
        return this.buffout.getClass() == HeapBytez.class && ((HeapBytez)this.buffout).getOffsetIndex() == 0L;
    }

    @Override
    public void registerClass(Class possible) {
        this.clnames.registerClass(possible, this.conf);
    }

    @Override
    public final void writeClass(Class cl) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, cl);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public final void writeClass(FSTClazzInfo clInf) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, clInf);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    private void writePlainLong(long v) throws IOException {
        this.ensureFree(8);
        this.buffout.putLong(this.pos, v);
        this.pos += 8L;
    }

    private void writePlainShort(int v) throws IOException {
        this.ensureFree(2);
        this.buffout.putShort(this.pos, (short)v);
        this.pos += 2L;
    }

    private void writePlainChar(int v) throws IOException {
        this.ensureFree(2);
        this.buffout.putChar(this.pos, (char)v);
        this.pos += 2L;
    }

    private void writePlainInt(int v) throws IOException {
        this.ensureFree(4);
        this.buffout.putInt(this.pos, v);
        this.pos += 4L;
    }

    @Override
    public void externalEnd(FSTClazzInfo clz) {
    }

    @Override
    public boolean isWritingAttributes() {
        return false;
    }

    @Override
    public boolean isPrimitiveArray(Object array, Class<?> componentType) {
        return componentType.isPrimitive();
    }

    @Override
    public boolean isTagMultiDimSubArrays() {
        return false;
    }

    @Override
    public void writeVersionTag(int version) throws IOException {
        this.writeFByte(version);
    }

    @Override
    public boolean isByteArrayBased() {
        return this.isPlainBAAccessible();
    }

    @Override
    public void writeArrayEnd() {
    }

    @Override
    public void writeFieldsEnd(FSTClazzInfo serializationInfo) {
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }
}

