/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.serialization.serializers;

import io.hops.hadoop.shaded.org.nustaq.serialization.FSTBasicObjectSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import java.io.IOException;

public class FSTBigNumberSerializers {

    public static class FSTDoubleSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeDouble((Double)toWrite);
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Double res = new Double(in.readDouble());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTFloatSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeFloat(((Float)toWrite).floatValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Float res = new Float(in.readFloat());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTShortSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeShort(((Short)toWrite).shortValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Short res = in.readShort();
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTCharSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeChar(((Character)toWrite).charValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Character res = Character.valueOf(in.readChar());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTByteSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeByte(((Byte)toWrite).byteValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Byte res = in.readByte();
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }
}

