/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.offheapstore.disk.storage;

import io.hops.hadoop.shaded.org.terracotta.offheapstore.disk.storage.Region;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.util.AATreeSet;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.util.Validation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AATreeFileAllocator
extends AATreeSet<Region> {
    private static final boolean VALIDATING = Validation.shouldValidate(AATreeFileAllocator.class);
    private static final int MAGIC = 1128813129;
    private static final int MAGIC_REGION = 1398034256;
    private final long capacity;
    private long occupied;

    public AATreeFileAllocator(long size) {
        this.capacity = size;
        this.add(new Region(0L, this.capacity - 1L));
    }

    public AATreeFileAllocator(long size, DataInput input) throws IOException {
        int magic;
        this.capacity = size;
        this.occupied = size;
        if (input.readInt() != 1128813129) {
            throw new IOException("Invalid magic number");
        }
        while ((magic = input.readInt()) != -1) {
            if (magic != 1398034256) {
                throw new IOException("Invalid magic number");
            }
            long start = input.readLong();
            long end = input.readLong();
            Region r = new Region(start, end);
            this.add(r);
            this.freed(r);
        }
    }

    public long allocate(long size) {
        Region r;
        if (Long.bitCount(size) != 1) {
            size = Long.highestOneBit(size) << 1;
        }
        if ((r = this.find(size)) == null) {
            return -1L;
        }
        Region current = this.removeAndReturn(r.start());
        Region newRange = current.remove(r);
        if (newRange != null) {
            this.add(current);
            this.add(newRange);
        } else if (!current.isNull()) {
            this.add(current);
        }
        this.allocated(r);
        return r.start();
    }

    public void free(long address, long length) {
        if (Long.bitCount(length) != 1) {
            length = Long.highestOneBit(length) << 1;
        }
        if (length != 0L) {
            Region r = new Region(address, address + length - 1L);
            this.free(r);
            this.freed(r);
        }
    }

    @Override
    public Region removeAndReturn(Object o) {
        Region r = (Region)super.removeAndReturn(o);
        if (r != null) {
            return new Region(r);
        }
        return null;
    }

    @Override
    public Region find(Object o) {
        Region r = (Region)super.find(o);
        if (r != null) {
            return new Region(r);
        }
        return null;
    }

    public long occupied() {
        return this.occupied;
    }

    public long capacity() {
        return this.capacity;
    }

    private void allocated(Region r) {
        this.occupied += r.size();
    }

    private void freed(Region r) {
        this.occupied -= r.size();
    }

    private void free(Region r) {
        Region prev = this.removeAndReturn(r.start() - 1L);
        if (prev != null) {
            prev.merge(r);
            Region next = this.removeAndReturn(r.end() + 1L);
            if (next != null) {
                prev.merge(next);
            }
            this.add(prev);
            return;
        }
        Region next = this.removeAndReturn(r.end() + 1L);
        if (next != null) {
            next.merge(r);
            this.add(next);
            return;
        }
        this.add(r);
    }

    private Region find(long size) {
        Validation.validate(!VALIDATING || Long.bitCount(size) == 1);
        AATreeSet.Node currentNode = this.getRoot();
        Region currentRegion = (Region)currentNode.getPayload();
        if (currentRegion == null || (currentRegion.available() & size) == 0L) {
            return null;
        }
        while (true) {
            Region left;
            if ((left = (Region)currentNode.getLeft().getPayload()) != null && (left.available() & size) != 0L) {
                currentNode = currentNode.getLeft();
                currentRegion = (Region)currentNode.getPayload();
                continue;
            }
            if ((currentRegion.availableHere() & size) != 0L) {
                long mask = size - 1L;
                long a = currentRegion.start() + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                return new Region(a, a + size - 1L);
            }
            Region right = (Region)currentNode.getRight().getPayload();
            if (right == null || (right.available() & size) == 0L) break;
            currentNode = currentNode.getRight();
            currentRegion = (Region)currentNode.getPayload();
        }
        throw new AssertionError();
    }

    @Override
    public String toString() {
        return "RegionSet = { " + super.toString() + " }";
    }

    void persist(DataOutput output) throws IOException {
        output.writeInt(1128813129);
        for (Region r : this) {
            this.persist(output, r);
        }
        output.writeInt(-1);
    }

    void persist(DataOutput output, Region r) throws IOException {
        output.writeInt(1398034256);
        output.writeLong(r.start());
        output.writeLong(r.end());
    }
}

