/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.StorageDataAccess;
import io.hops.metadata.hdfs.dal.StorageIdMapDataAccess;
import io.hops.metadata.hdfs.entity.Storage;
import io.hops.metadata.hdfs.entity.StorageId;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

public class StorageMap {
    private static final Log LOG = LogFactory.getLog(StorageMap.class);
    private Map<String, Integer> storageIdtoSId = Collections.synchronizedMap(new HashMap());
    private Map<Integer, DatanodeStorageInfo> storageInfoMap = Collections.synchronizedMap(new HashMap());
    private Map<String, ArrayList<Integer>> datanodeUuidToSids = Collections.synchronizedMap(new HashMap());

    public StorageMap() throws IOException {
        this(true);
    }

    public StorageMap(boolean loadFromDB) throws IOException {
        if (loadFromDB) {
            this.initialize();
        }
    }

    private void initialize() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.INITIALIZE_SID_MAP){

            public Object performTask() throws StorageException, IOException {
                StorageDataAccess da = (StorageDataAccess)HdfsStorageFactory.getDataAccess(StorageDataAccess.class);
                Collection entries = da.findAll();
                for (Storage sid : entries) {
                    ArrayList<Integer> sids = (ArrayList<Integer>)StorageMap.this.datanodeUuidToSids.get(sid.getHostID());
                    if (sids == null) {
                        sids = new ArrayList<Integer>();
                    }
                    sids.add(sid.getStorageID());
                    StorageMap.this.datanodeUuidToSids.put(sid.getHostID(), sids);
                }
                StorageIdMapDataAccess sda = (StorageIdMapDataAccess)HdfsStorageFactory.getDataAccess(StorageIdMapDataAccess.class);
                Collection sids = sda.findAll();
                if (sids == null) {
                    return null;
                }
                for (StorageId h : sids) {
                    StorageMap.this.storageIdtoSId.put(h.getStorageId(), h.getsId());
                }
                return null;
            }
        }.handle();
    }

    public void updateStorage(DatanodeStorageInfo storageInfo) throws IOException {
        String storageUuid = storageInfo.getStorageID();
        storageInfo.setSid(this.getSetSId(storageUuid));
        final int sid = storageInfo.getSid();
        final String datanodeUuid = storageInfo.getDatanodeDescriptor().getDatanodeUuid();
        final int storageType = storageInfo.getStorageType().ordinal();
        final String state = storageInfo.getState().toString();
        ArrayList<Integer> sids = this.datanodeUuidToSids.get(datanodeUuid);
        if (sids == null) {
            sids = new ArrayList();
            this.datanodeUuidToSids.put(datanodeUuid, sids);
        }
        if (!sids.contains(sid)) {
            sids.add(sid);
            new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_SID_MAP){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getVariableLock(Variable.Finder.StorageMap, TransactionLockTypes.LockType.READ_COMMITTED));
                }

                public Object performTask() throws StorageException, IOException {
                    StorageDataAccess da = (StorageDataAccess)HdfsStorageFactory.getDataAccess(StorageDataAccess.class);
                    Storage h = (Storage)da.findByPk(sid);
                    if (h == null) {
                        h = new Storage(sid, datanodeUuid, storageType, state);
                        da.add((Object)h);
                    }
                    return null;
                }
            }.handle();
        }
        this.storageInfoMap.put(storageInfo.getSid(), storageInfo);
    }

    private int getSetSId(final String storageUuid) throws IOException {
        if (this.storageIdtoSId.containsKey(storageUuid)) {
            return this.storageIdtoSId.get(storageUuid);
        }
        return (Integer)new HopsTransactionalRequestHandler(HDFSOperationType.GET_SET_SID){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.SIdCounter, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                int currSIdCount = HdfsVariables.getSIdCounter();
                StorageIdMapDataAccess da = (StorageIdMapDataAccess)HdfsStorageFactory.getDataAccess(StorageIdMapDataAccess.class);
                StorageId h = (StorageId)da.findByPk(storageUuid);
                if (h == null) {
                    h = new StorageId(storageUuid, currSIdCount);
                    da.add((Object)h);
                    HdfsVariables.setSIdCounter(++currSIdCount);
                }
                StorageMap.this.storageIdtoSId.put(storageUuid, h.getsId());
                return h.getsId();
            }
        }.handle();
    }

    public int getSId(String storageId) {
        return this.storageIdtoSId.get(storageId);
    }

    public DatanodeStorageInfo getStorage(int sid) {
        return this.storageInfoMap.get(sid);
    }

    public List<Integer> getSidsForDatanodeUuid(String datanodeUuid) {
        return this.datanodeUuidToSids.get(datanodeUuid);
    }

    public Collection<Integer> getAllSid() {
        return this.storageIdtoSId.values();
    }
}

