/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.application;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.google.protobuf.ByteString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.ssl.JWTSecurityMaterial;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ApplicationLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppStartedEvent;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationImpl
implements Application {
    final Dispatcher dispatcher;
    final String user;
    private FlowContext flowContext;
    final ApplicationId appId;
    final Credentials credentials;
    Map<ApplicationAccessType, String> applicationACLs;
    final ApplicationACLsManager aclsManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Context context;
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationImpl.class);
    private LogAggregationContext logAggregationContext;
    Map<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();
    private final AtomicInteger x509Version;
    private final AtomicLong jwtExpiration;
    private long applicationLogInitedTimestamp = -1L;
    private final NMStateStoreService appStateStore;
    private static final ContainerDoneTransition CONTAINER_DONE_TRANSITION = new ContainerDoneTransition();
    private static final InitContainerTransition INIT_CONTAINER_TRANSITION = new InitContainerTransition();
    private static StateMachineFactory<ApplicationImpl, ApplicationState, ApplicationEventType, ApplicationEvent> stateMachineFactory = new StateMachineFactory((Enum)ApplicationState.NEW).addTransition((Enum)ApplicationState.NEW, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.INIT_APPLICATION, (SingleArcTransition)new AppInitTransition()).addTransition((Enum)ApplicationState.NEW, (Enum)ApplicationState.NEW, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.INITING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.FINISH_APPLICATION, (MultipleArcTransition)new AppFinishTriggeredTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition)CONTAINER_DONE_TRANSITION).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, (SingleArcTransition)new AppLogInitDoneTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, (SingleArcTransition)new AppLogInitFailTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.APPLICATION_INITED, (SingleArcTransition)new AppInitDoneTransition()).addTransition((Enum)ApplicationState.RUNNING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.RUNNING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition)CONTAINER_DONE_TRANSITION).addTransition((Enum)ApplicationState.RUNNING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.FINISH_APPLICATION, (MultipleArcTransition)new AppFinishTriggeredTransition()).addTransition((Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (MultipleArcTransition)new AppFinishTransition()).addTransition((Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, (Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, (Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.FINISHED, (Enum)ApplicationEventType.APPLICATION_RESOURCES_CLEANEDUP, (SingleArcTransition)new AppCompletelyDoneTransition()).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition((Enum)ApplicationState.FINISHED, (Enum)ApplicationState.FINISHED, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED), (SingleArcTransition)new AppLogsAggregatedTransition()).addTransition((Enum)ApplicationState.FINISHED, (Enum)ApplicationState.FINISHED, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)INIT_CONTAINER_TRANSITION).addTransition((Enum)ApplicationState.FINISHED, (Enum)ApplicationState.FINISHED, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_CONTAINER_FINISHED, ApplicationEventType.FINISH_APPLICATION)).installTopology();
    private final StateMachine<ApplicationState, ApplicationEventType, ApplicationEvent> stateMachine;

    public ApplicationImpl(Dispatcher dispatcher, String user, ApplicationId appId, Credentials credentials, Context context) {
        this(dispatcher, user, null, appId, credentials, context, -1L, 0, -1L);
    }

    public ApplicationImpl(Dispatcher dispatcher, String user, FlowContext flowContext, ApplicationId appId, Credentials credentials, Context context, int x509Version, long jwtExpiration) {
        this(dispatcher, user, flowContext, appId, credentials, context, -1L, x509Version, jwtExpiration);
    }

    public ApplicationImpl(Dispatcher dispatcher, String user, FlowContext flowContext, ApplicationId appId, Credentials credentials, Context context, long recoveredLogInitedTime) {
        this(dispatcher, user, flowContext, appId, credentials, context, recoveredLogInitedTime, 0, -1L);
    }

    public ApplicationImpl(Dispatcher dispatcher, String user, FlowContext flowContext, ApplicationId appId, Credentials credentials, Context context, long recoveredLogInitedTime, int x509Version, long jwtExpiration) {
        this.dispatcher = dispatcher;
        this.user = user;
        this.appId = appId;
        this.credentials = credentials;
        this.aclsManager = context.getApplicationACLsManager();
        Configuration conf = context.getConf();
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            if (flowContext == null) {
                throw new IllegalArgumentException("flow context cannot be null");
            }
            this.flowContext = flowContext;
            if (YarnConfiguration.systemMetricsPublisherEnabled((Configuration)conf)) {
                context.getNMTimelinePublisher().createTimelineClient(appId);
            }
        }
        this.context = context;
        this.appStateStore = context.getNMStateStore();
        this.x509Version = new AtomicInteger(x509Version);
        this.jwtExpiration = new AtomicLong(jwtExpiration);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.setAppLogInitedTimestamp(recoveredLogInitedTime);
    }

    public ApplicationImpl(Dispatcher dispatcher, String user, FlowContext flowContext, ApplicationId appId, Credentials credentials, Context context) {
        this(dispatcher, user, flowContext, appId, credentials, context, -1L, 0, -1L);
    }

    @Override
    public String getUser() {
        return this.user.toString();
    }

    @Override
    public ApplicationId getAppId() {
        return this.appId;
    }

    @Override
    public ApplicationState getApplicationState() {
        this.readLock.lock();
        try {
            ApplicationState applicationState = (ApplicationState)this.stateMachine.getCurrentState();
            return applicationState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<ContainerId, Container> getContainers() {
        this.readLock.lock();
        try {
            Map<ContainerId, Container> map = this.containers;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getX509Version() {
        return this.x509Version.get();
    }

    @Override
    public void setX509Version(int x509Version) {
        this.x509Version.set(x509Version);
    }

    @Override
    public long getJWTExpiration() {
        return this.jwtExpiration.get();
    }

    @Override
    public void setJWTExpiration(long jwtExpiration) {
        this.jwtExpiration.set(jwtExpiration);
    }

    @VisibleForTesting
    void setAppLogInitedTimestamp(long appLogInitedTimestamp) {
        this.applicationLogInitedTimestamp = appLogInitedTimestamp;
    }

    static YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto buildAppProto(ApplicationImpl app) throws IOException, InterruptedException {
        YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.Builder builder = YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.newBuilder();
        builder.setId(((ApplicationIdPBImpl)app.appId).getProto());
        builder.setUser(app.getUser());
        if (app.logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)app.logAggregationContext).getProto());
        }
        builder.clearCredentials();
        if (app.credentials != null) {
            DataOutputBuffer dob = new DataOutputBuffer();
            app.credentials.writeTokenStorageToStream((DataOutputStream)dob);
            builder.setCredentials(ByteString.copyFrom((byte[])dob.getData()));
        }
        builder.clearAcls();
        if (app.applicationACLs != null) {
            for (Map.Entry entry : app.applicationACLs.entrySet()) {
                YarnProtos.ApplicationACLMapProto p = YarnProtos.ApplicationACLMapProto.newBuilder().setAccessType(ProtoUtils.convertToProtoFormat((ApplicationAccessType)((ApplicationAccessType)entry.getKey()))).setAcl((String)entry.getValue()).build();
                builder.addAcls(p);
            }
        }
        builder.setAppLogAggregationInitedTime(app.applicationLogInitedTimestamp);
        builder.clearFlowContext();
        if (app.flowContext != null && app.flowContext.getFlowName() != null && app.flowContext.getFlowVersion() != null) {
            YarnServerNodemanagerRecoveryProtos.FlowContextProto fcp = YarnServerNodemanagerRecoveryProtos.FlowContextProto.newBuilder().setFlowName(app.flowContext.getFlowName()).setFlowVersion(app.flowContext.getFlowVersion()).setFlowRunId(app.flowContext.getFlowRunId()).build();
            builder.setFlowContext(fcp);
        }
        if (((NodeManager.NMContext)app.context).isHopsTLSEnabled()) {
            ByteBuffer trustStore;
            X509SecurityMaterial x509SecurityMaterial = app.context.getCertificateLocalizationService().getX509MaterialLocation(app.getUser(), app.getAppId().toString());
            ByteBuffer byteBuffer = x509SecurityMaterial.getKeyStoreMem();
            if (byteBuffer != null) {
                builder.setKeyStore(ProtoUtils.convertToProtoFormat((ByteBuffer)byteBuffer));
                builder.setKeyStorePassword(String.valueOf(x509SecurityMaterial.getKeyStorePass()));
            }
            if ((trustStore = x509SecurityMaterial.getTrustStoreMem()) != null) {
                builder.setTrustStore(ProtoUtils.convertToProtoFormat((ByteBuffer)trustStore));
                builder.setTrustStorePassword(String.valueOf(x509SecurityMaterial.getTrustStorePass()));
            }
            builder.setCryptoVersion(app.getX509Version());
        }
        if (((NodeManager.NMContext)app.context).isJWTEnabled()) {
            JWTSecurityMaterial jwtSecurityMaterial = app.context.getCertificateLocalizationService().getJWTMaterialLocation(app.getUser(), app.getAppId().toString());
            String string = jwtSecurityMaterial.getToken();
            if (string != null) {
                builder.setJwt(string);
            }
            if (app.getJWTExpiration() != -1L) {
                builder.setJwtExpiration(app.getJWTExpiration());
            }
        }
        return builder.build();
    }

    void handleAppFinishWithContainersCleanedup() {
        this.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.DESTROY_APPLICATION_RESOURCES, this));
        this.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.APPLICATION_STOP, this.appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ApplicationEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId applicationID = event.getApplicationID();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing " + applicationID + " of type " + event.getType());
            }
            ApplicationState oldState = (ApplicationState)this.stateMachine.getCurrentState();
            ApplicationState newState = null;
            try {
                newState = (ApplicationState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn("Can't handle this event at current state", (Throwable)e);
            }
            if (newState != null && oldState != newState) {
                LOG.info("Application " + applicationID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.appId.toString();
    }

    @VisibleForTesting
    public LogAggregationContext getLogAggregationContext() {
        try {
            this.readLock.lock();
            LogAggregationContext logAggregationContext = this.logAggregationContext;
            return logAggregationContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getFlowName() {
        return this.flowContext == null ? null : this.flowContext.getFlowName();
    }

    @Override
    public String getFlowVersion() {
        return this.flowContext == null ? null : this.flowContext.getFlowVersion();
    }

    @Override
    public long getFlowRunId() {
        return this.flowContext == null ? 0L : this.flowContext.getFlowRunId();
    }

    public void setFlowContext(FlowContext fc) {
        this.flowContext = fc;
    }

    static class AppLogsAggregatedTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogsAggregatedTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            boolean isJWTEnabled;
            ApplicationId appId = event.getApplicationID();
            app.context.getApplications().remove(appId);
            app.aclsManager.removeApplication(appId);
            boolean isHopsTLSEnabled = ((NodeManager.NMContext)app.context).isHopsTLSEnabled();
            if (isHopsTLSEnabled) {
                try {
                    app.context.getCertificateLocalizationService().removeX509Material(app.getUser(), appId.toString());
                }
                catch (InterruptedException ex) {
                    LOG.error("Error while deleting X.509 for application " + appId);
                }
            }
            if (isJWTEnabled = ((NodeManager.NMContext)app.context).isJWTEnabled()) {
                try {
                    app.context.getCertificateLocalizationService().removeJWTMaterial(app.getUser(), appId.toString());
                }
                catch (InterruptedException ex) {
                    LOG.error("Error while deleting JWT for application " + appId);
                }
            }
            try {
                app.context.getNMStateStore().removeApplication(appId);
            }
            catch (IOException e) {
                LOG.error("Unable to remove application from state store", (Throwable)e);
            }
        }
    }

    static class AppCompletelyDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppCompletelyDoneTransition() {
        }

        private void updateCollectorStatus(ApplicationImpl app) {
            NMTimelinePublisher nmTimelinePublisher;
            ConcurrentMap<ApplicationId, AppCollectorData> knownCollectors;
            ConcurrentMap<ApplicationId, AppCollectorData> registeringCollectors = app.context.getRegisteringCollectors();
            if (registeringCollectors != null) {
                registeringCollectors.remove(app.getAppId());
            }
            if ((knownCollectors = app.context.getKnownCollectors()) != null) {
                knownCollectors.remove(app.getAppId());
            }
            if ((nmTimelinePublisher = app.context.getNMTimelinePublisher()) != null) {
                nmTimelinePublisher.stopTimelineClient(app.getAppId());
            }
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle((Event)new LogHandlerAppFinishedEvent(app.appId));
            app.context.getNMTokenSecretManager().appFinished(app.getAppId());
            this.updateCollectorStatus(app);
        }
    }

    static class AppFinishTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTransition() {
        }

        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerFinishEvent = (ApplicationContainerFinishedEvent)event;
            LOG.info("Removing " + containerFinishEvent.getContainerID() + " from application " + app.toString());
            app.containers.remove(containerFinishEvent.getContainerID());
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static class AppFinishTriggeredTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTriggeredTransition() {
        }

        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationFinishEvent appEvent = (ApplicationFinishEvent)event;
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            for (ContainerId containerID : app.containers.keySet()) {
                app.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, -107, "Container killed on application-finish event: " + appEvent.getDiagnostic()));
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static final class ContainerDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        ContainerDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerEvent = (ApplicationContainerFinishedEvent)event;
            if (null == app.containers.remove(containerEvent.getContainerID())) {
                LOG.warn("Removing unknown " + containerEvent.getContainerID() + " from application " + app.toString());
            } else {
                LOG.info("Removing " + containerEvent.getContainerID() + " from application " + app.toString());
            }
        }
    }

    static class AppInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            for (Container container : app.containers.values()) {
                app.dispatcher.getEventHandler().handle((Event)new ContainerInitEvent(container.getContainerId()));
            }
        }
    }

    static class InitContainerTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        InitContainerTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerInitEvent initEvent = (ApplicationContainerInitEvent)event;
            Container container = initEvent.getContainer();
            app.containers.put(container.getContainerId(), container);
            LOG.info("Adding " + container.getContainerId() + " to application " + app.toString());
            ApplicationState appState = app.getApplicationState();
            switch (appState) {
                case RUNNING: {
                    app.dispatcher.getEventHandler().handle((Event)new ContainerInitEvent(container.getContainerId()));
                    break;
                }
                case INITING: 
                case NEW: {
                    break;
                }
                default: {
                    LOG.warn("Killing {} because {} is in state {}", new Object[]{container.getContainerId(), app, appState});
                    app.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(container.getContainerId(), -107, "Application no longer running.\n"));
                }
            }
        }
    }

    static class AppLogInitFailTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitFailTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            LOG.warn("Log Aggregation service failed to initialize, there will be no logs for this application");
            app.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
        }
    }

    static class AppLogInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
            app.setAppLogInitedTimestamp(event.getTimestamp());
            try {
                app.appStateStore.storeApplication(app.appId, ApplicationImpl.buildAppProto(app));
            }
            catch (Exception ex) {
                LOG.warn("failed to update application state in state store", (Throwable)ex);
            }
        }
    }

    static class AppInitTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationInitEvent initEvent = (ApplicationInitEvent)event;
            app.applicationACLs = initEvent.getApplicationACLs();
            app.aclsManager.addApplication(app.getAppId(), app.applicationACLs);
            app.logAggregationContext = initEvent.getLogAggregationContext();
            app.dispatcher.getEventHandler().handle((Event)new LogHandlerAppStartedEvent(app.appId, app.user, app.credentials, app.applicationACLs, app.logAggregationContext, app.applicationLogInitedTimestamp));
        }
    }

    public static class FlowContext {
        private final String flowName;
        private final String flowVersion;
        private final long flowRunId;

        public FlowContext(String flowName, String flowVersion, long flowRunId) {
            this.flowName = flowName;
            this.flowVersion = flowVersion;
            this.flowRunId = flowRunId;
        }

        public String getFlowName() {
            return this.flowName;
        }

        public String getFlowVersion() {
            return this.flowVersion;
        }

        public long getFlowRunId() {
            return this.flowRunId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            sb.append("Flow Name=").append(this.getFlowName());
            sb.append(" Flow Versioin=").append(this.getFlowVersion());
            sb.append(" Flow Run Id=").append(this.getFlowRunId()).append(" }");
            return sb.toString();
        }
    }
}

