/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import io.hops.hadoop.shaded.com.google.inject.Inject;
import io.hops.hadoop.shaded.com.google.inject.Singleton;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.ws.rs.GET;
import io.hops.hadoop.shaded.javax.ws.rs.Path;
import io.hops.hadoop.shaded.javax.ws.rs.PathParam;
import io.hops.hadoop.shaded.javax.ws.rs.Produces;
import io.hops.hadoop.shaded.javax.ws.rs.QueryParam;
import io.hops.hadoop.shaded.javax.ws.rs.WebApplicationException;
import io.hops.hadoop.shaded.javax.ws.rs.core.GenericEntity;
import io.hops.hadoop.shaded.javax.ws.rs.core.Response;
import io.hops.hadoop.shaded.javax.ws.rs.core.StreamingOutput;
import io.hops.hadoop.shaded.javax.ws.rs.core.UriInfo;
import io.hops.hadoop.shaded.org.apache.commons.io.IOUtils;
import io.hops.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePluginManager;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMContainerLogsInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/node")
public class NMWebServices {
    private static final Logger LOG = LoggerFactory.getLogger(NMWebServices.class);
    private Context nmContext;
    private ResourceView rview;
    private WebApp webapp;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final String redirectWSUrl;
    private final LogAggregationFileControllerFactory factory;
    private boolean filterAppsByUser = false;
    @io.hops.hadoop.shaded.javax.ws.rs.core.Context
    private HttpServletRequest request;
    @io.hops.hadoop.shaded.javax.ws.rs.core.Context
    private HttpServletResponse response;
    @io.hops.hadoop.shaded.javax.ws.rs.core.Context
    UriInfo uriInfo;

    @Inject
    public NMWebServices(Context nm, ResourceView view, WebApp webapp) {
        this.nmContext = nm;
        this.rview = view;
        this.webapp = webapp;
        this.redirectWSUrl = this.nmContext.getConf().get("yarn.log.server.web-service.url");
        this.factory = new LogAggregationFileControllerFactory(this.nmContext.getConf());
        this.filterAppsByUser = this.nmContext.getConf().getBoolean("yarn.webapp.filter-entity-list-by-user", false);
    }

    public NMWebServices(Context nm, ResourceView view, WebApp webapp, HttpServletResponse response) {
        this(nm, view, webapp);
        this.response = response;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeInfo get() {
        return this.getNodeInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeInfo getNodeInfo() {
        this.init();
        return new NodeInfo(this.nmContext, this.rview);
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getNodeApps(@io.hops.hadoop.shaded.javax.ws.rs.core.Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="user") String userQuery) {
        this.init();
        AppsInfo allApps = new AppsInfo();
        for (Map.Entry entry : this.nmContext.getApplications().entrySet()) {
            AppInfo appInfo = new AppInfo((Application)entry.getValue());
            if (stateQuery != null && !stateQuery.isEmpty()) {
                ApplicationState.valueOf(stateQuery);
                if (!appInfo.getState().equalsIgnoreCase(stateQuery)) continue;
            }
            if (userQuery != null) {
                if (userQuery.isEmpty()) {
                    String msg = "Error: You must specify a non-empty string for the user";
                    throw new BadRequestException(msg);
                }
                if (!appInfo.getUser().equals(userQuery)) continue;
            }
            if (this.filterAppsByUser && !this.hasAccess(appInfo.getUser(), (ApplicationId)entry.getKey(), hsr).booleanValue()) continue;
            allApps.add(appInfo);
        }
        return allApps;
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getNodeApp(@PathParam(value="appid") String appId) {
        this.init();
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        Application app = (Application)this.nmContext.getApplications().get(id);
        if (app == null) {
            throw new NotFoundException("app with id " + appId + " not found");
        }
        return new AppInfo(app);
    }

    @GET
    @Path(value="/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getNodeContainers(@io.hops.hadoop.shaded.javax.ws.rs.core.Context HttpServletRequest hsr) {
        this.init();
        ContainersInfo allContainers = new ContainersInfo();
        for (Map.Entry entry : this.nmContext.getContainers().entrySet()) {
            if (entry.getValue() == null) continue;
            ContainerInfo info = new ContainerInfo(this.nmContext, (Container)entry.getValue(), this.uriInfo.getBaseUri().toString(), this.webapp.name(), hsr.getRemoteUser());
            ApplicationId appId = ((ContainerId)entry.getKey()).getApplicationAttemptId().getApplicationId();
            if (this.filterAppsByUser && !this.hasAccess(((Container)entry.getValue()).getUser(), appId, hsr).booleanValue()) continue;
            allContainers.add(info);
        }
        return allContainers;
    }

    @GET
    @Path(value="/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getNodeContainer(@io.hops.hadoop.shaded.javax.ws.rs.core.Context HttpServletRequest hsr, @PathParam(value="containerid") String id) {
        ContainerId containerId = null;
        this.init();
        try {
            containerId = ContainerId.fromString((String)id);
        }
        catch (Exception e) {
            throw new BadRequestException("invalid container id, " + id);
        }
        Container container = (Container)this.nmContext.getContainers().get(containerId);
        if (container == null) {
            throw new NotFoundException("container with id, " + id + ", not found");
        }
        return new ContainerInfo(this.nmContext, container, this.uriInfo.getBaseUri().toString(), this.webapp.name(), hsr.getRemoteUser());
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response getContainerLogsInfo(@io.hops.hadoop.shaded.javax.ws.rs.core.Context HttpServletRequest hsr, @io.hops.hadoop.shaded.javax.ws.rs.core.Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr) {
        ContainerId containerId = null;
        this.init();
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        try {
            ArrayList<ContainerLogsInfo> containersLogsInfo;
            block9: {
                containersLogsInfo = new ArrayList<ContainerLogsInfo>();
                containersLogsInfo.add(new NMContainerLogsInfo(this.nmContext, containerId, hsr.getRemoteUser(), ContainerLogAggregationType.LOCAL));
                ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                Application app = (Application)this.nmContext.getApplications().get(appId);
                String appOwner = app == null ? null : app.getUser();
                try {
                    ContainerLogsRequest logRequest = new ContainerLogsRequest();
                    logRequest.setAppId(appId);
                    logRequest.setAppOwner(appOwner);
                    logRequest.setContainerId(containerIdStr);
                    logRequest.setNodeId(this.nmContext.getNodeId().toString());
                    List containerLogMeta = this.factory.getFileControllerForRead(appId, appOwner).readAggregatedLogsMeta(logRequest);
                    if (!containerLogMeta.isEmpty()) {
                        for (ContainerLogMeta logMeta : containerLogMeta) {
                            containersLogsInfo.add(new ContainerLogsInfo(logMeta, ContainerLogAggregationType.AGGREGATED));
                        }
                    }
                }
                catch (IOException ex) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug(ex.getMessage());
                }
            }
            GenericEntity<List<ContainerLogsInfo>> meta = new GenericEntity<List<ContainerLogsInfo>>(containersLogsInfo){};
            Response.ResponseBuilder resp = Response.ok((Object)meta);
            resp.header("X-Content-Type-Options", (Object)"nosniff");
            return resp.build();
        }
        catch (Exception ex) {
            if (this.redirectWSUrl == null || this.redirectWSUrl.isEmpty()) {
                throw new WebApplicationException((Throwable)ex);
            }
            String redirectURI = "/containers/" + containerIdStr + "/logs";
            return this.createRedirectResponse(hsr, this.redirectWSUrl, redirectURI);
        }
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size) {
        return this.getLogs(containerIdStr, filename, format, size);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(final @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size) {
        boolean tempIsRunning;
        ContainerId containerId;
        block11: {
            ContainerId tempContainerId;
            try {
                tempContainerId = ContainerId.fromString((String)containerIdStr);
            }
            catch (IllegalArgumentException ex) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            containerId = tempContainerId;
            tempIsRunning = false;
            try {
                Container container = (Container)this.nmContext.getContainers().get(containerId);
                tempIsRunning = container.getContainerState() == ContainerState.RUNNING;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug("Can not find the container:" + containerId + " in this node.");
            }
        }
        final boolean isRunning = tempIsRunning;
        File logFile = null;
        try {
            logFile = ContainerLogsUtils.getContainerLogFile(containerId, filename, this.request.getRemoteUser(), this.nmContext);
        }
        catch (NotFoundException ex) {
            if (this.redirectWSUrl == null || this.redirectWSUrl.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ex.getMessage()).build();
            }
            String redirectURI = "/containers/" + containerIdStr + "/logs/" + filename;
            return this.createRedirectResponse(this.request, this.redirectWSUrl, redirectURI);
        }
        catch (YarnException ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
        final long bytes = this.parseLongParam(size);
        final String lastModifiedTime = Times.format((long)logFile.lastModified());
        final String outputFileName = filename;
        String contentType = WebAppUtils.getDefaultLogContentType();
        if (format != null && !format.isEmpty() && (contentType = WebAppUtils.getSupportedLogContentType((String)format)) == null) {
            String errorMessage = "The valid values for the parameter : format are " + WebAppUtils.listSupportedLogContentType();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        try {
            final FileInputStream fis = ContainerLogsUtils.openLogFileForRead(containerIdStr, logFile, this.nmContext);
            final long fileLength = logFile.length();
            StreamingOutput stream = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(OutputStream os) throws IOException, WebApplicationException {
                    try {
                        LogToolUtils.outputContainerLogThroughZeroCopy((String)containerId.toString(), (String)NMWebServices.this.nmContext.getNodeId().toString(), (String)outputFileName, (long)fileLength, (long)bytes, (String)lastModifiedTime, (FileInputStream)fis, (OutputStream)os, (ContainerLogAggregationType)ContainerLogAggregationType.LOCAL);
                        StringBuilder sb = new StringBuilder();
                        String endOfFile = "End of LogType:" + outputFileName;
                        sb.append(endOfFile + ".");
                        if (isRunning) {
                            sb.append("This log file belongs to a running container (" + containerIdStr + ") and so may not be complete.\n");
                        } else {
                            sb.append("\n");
                        }
                        sb.append(StringUtils.repeat((String)"*", (int)(endOfFile.length() + 50)) + "\n\n");
                        os.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                        Application app = (Application)NMWebServices.this.nmContext.getApplications().get(appId);
                        String appOwner = app == null ? null : app.getUser();
                        try {
                            ContainerLogsRequest logRequest = new ContainerLogsRequest();
                            logRequest.setAppId(appId);
                            logRequest.setAppOwner(appOwner);
                            logRequest.setContainerId(containerId.toString());
                            logRequest.setNodeId(NMWebServices.this.nmContext.getNodeId().toString());
                            logRequest.setBytes(bytes);
                            HashSet<String> logTypes = new HashSet<String>();
                            logTypes.add(outputFileName);
                            logRequest.setLogTypes(logTypes);
                            NMWebServices.this.factory.getFileControllerForRead(appId, appOwner).readAggregatedLogs(logRequest, os);
                        }
                        catch (Exception ex) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Can not access the aggregated log for the container:" + containerId);
                                LOG.debug(ex.getMessage());
                            }
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)fis);
                    }
                }
            };
            Response.ResponseBuilder resp = Response.ok((Object)stream);
            resp.header("Content-Type", (Object)(contentType + "; " + "charset=utf-8"));
            resp.header("X-Content-Type-Options", (Object)"nosniff");
            return resp.build();
        }
        catch (IOException ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
    }

    @GET
    @Path(value="/resources/{resourcename}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Object getNMResourceInfo(@PathParam(value="resourcename") String resourceName) throws YarnException {
        NMResourceInfo nmResourceInfo;
        ResourcePlugin plugin;
        this.init();
        ResourcePluginManager rpm = this.nmContext.getResourcePluginManager();
        if (rpm != null && rpm.getNameToPlugins() != null && (plugin = rpm.getNameToPlugins().get(resourceName)) != null && (nmResourceInfo = plugin.getNMResourceInfo()) != null) {
            return nmResourceInfo;
        }
        return new NMResourceInfo();
    }

    private long parseLongParam(String bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(bytes);
    }

    private Response createRedirectResponse(HttpServletRequest httpRequest, String redirectWSUrlPrefix, String uri) {
        StringBuilder redirectPath = new StringBuilder();
        if (redirectWSUrlPrefix.endsWith("/")) {
            redirectWSUrlPrefix = redirectWSUrlPrefix.substring(0, redirectWSUrlPrefix.length() - 1);
        }
        redirectPath.append(redirectWSUrlPrefix + uri);
        String requestParams = WebAppUtils.removeQueryParams((HttpServletRequest)httpRequest, (String)"nm.id");
        if (requestParams != null && !requestParams.isEmpty()) {
            redirectPath.append("?" + requestParams + "&" + "redirected_from_node" + "=true");
        } else {
            redirectPath.append("?redirected_from_node=true");
        }
        Response.ResponseBuilder res = Response.status((int)307);
        res.header("Location", (Object)redirectPath.toString());
        return res.build();
    }

    protected Boolean hasAccess(String user, ApplicationId appId, HttpServletRequest hsr) {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI != null && !this.nmContext.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, user, appId)) {
            return false;
        }
        return true;
    }

    private UserGroupInformation getCallerUserGroupInformation(HttpServletRequest hsr, boolean usePrincipal) {
        String remoteUser = hsr.getRemoteUser();
        if (usePrincipal) {
            Principal princ = hsr.getUserPrincipal();
            remoteUser = princ == null ? null : princ.getName();
        }
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }
}

