/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class StageAllocatorLowCostAligned
implements StageAllocator {
    private final boolean allocateLeft;
    private int smoothnessFactor = 10;

    public StageAllocatorLowCostAligned(boolean allocateLeft) {
        this.allocateLeft = allocateLeft;
    }

    public StageAllocatorLowCostAligned(int smoothnessFactor, boolean allocateLeft) {
        this.allocateLeft = allocateLeft;
        this.smoothnessFactor = smoothnessFactor;
    }

    @Override
    public Map<ReservationInterval, Resource> computeStageAllocation(Plan plan, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications, ReservationRequest rr, long stageArrival, long stageDeadline, long period, String user, ReservationId oldId) throws PlanningException {
        int remainingGangs;
        int numGangsToAllocate;
        ResourceCalculator resCalc = plan.getResourceCalculator();
        Resource capacity = plan.getTotalCapacity();
        RLESparseResourceAllocation netRLERes = plan.getAvailableResourceOverTime(user, oldId, stageArrival, stageDeadline, period);
        long step = plan.getStep();
        RLESparseResourceAllocation allocationRequests = new RLESparseResourceAllocation(plan.getResourceCalculator());
        long duration = StageAllocatorLowCostAligned.stepRoundUp(rr.getDuration(), step);
        int windowSizeInDurations = (int)((stageDeadline - stageArrival) / duration);
        int totalGangs = rr.getNumContainers() / rr.getConcurrency();
        int numContainersPerGang = rr.getConcurrency();
        Resource gang = Resources.multiply((Resource)rr.getCapability(), (double)numContainersPerGang);
        int maxGangsPerUnit = (int)Math.max(Math.floor((double)totalGangs / (double)windowSizeInDurations), 1.0);
        maxGangsPerUnit = Math.max(maxGangsPerUnit / this.smoothnessFactor, 1);
        if (windowSizeInDurations <= 0) {
            return null;
        }
        final int preferLeft = this.allocateLeft ? 1 : -1;
        TreeSet<DurationInterval> durationIntervalsSortedByCost = new TreeSet<DurationInterval>(new Comparator<DurationInterval>(){

            @Override
            public int compare(DurationInterval val1, DurationInterval val2) {
                int cmp = Double.compare(val1.getTotalCost(), val2.getTotalCost());
                if (cmp != 0) {
                    return cmp;
                }
                return preferLeft * Long.compare(val1.getEndTime(), val2.getEndTime());
            }
        });
        List<Long> intervalEndTimes = this.computeIntervalEndTimes(stageArrival, stageDeadline, duration);
        for (long intervalEnd : intervalEndTimes) {
            long intervalStart = intervalEnd - duration;
            DurationInterval durationInterval = StageAllocatorLowCostAligned.getDurationInterval(intervalStart, intervalEnd, planLoads, planModifications, capacity, netRLERes, resCalc, step, gang);
            if (!durationInterval.canAllocate()) continue;
            durationIntervalsSortedByCost.add(durationInterval);
        }
        for (remainingGangs = totalGangs; remainingGangs > 0 && !durationIntervalsSortedByCost.isEmpty(); remainingGangs -= numGangsToAllocate) {
            DurationInterval bestDurationInterval = durationIntervalsSortedByCost.first();
            numGangsToAllocate = Math.min(maxGangsPerUnit, remainingGangs);
            numGangsToAllocate = Math.min(numGangsToAllocate, bestDurationInterval.numCanFit());
            ReservationInterval reservationInt = new ReservationInterval(bestDurationInterval.getStartTime(), bestDurationInterval.getEndTime());
            Resource reservationRes = Resources.multiply((Resource)rr.getCapability(), (double)(rr.getConcurrency() * numGangsToAllocate));
            planModifications.addInterval(reservationInt, reservationRes);
            allocationRequests.addInterval(reservationInt, reservationRes);
            durationIntervalsSortedByCost.remove(bestDurationInterval);
            DurationInterval updatedDurationInterval = StageAllocatorLowCostAligned.getDurationInterval(bestDurationInterval.getStartTime(), bestDurationInterval.getStartTime() + duration, planLoads, planModifications, capacity, netRLERes, resCalc, step, gang);
            if (!updatedDurationInterval.canAllocate()) continue;
            durationIntervalsSortedByCost.add(updatedDurationInterval);
        }
        Map<ReservationInterval, Resource> allocations = allocationRequests.toIntervalMap();
        if (remainingGangs <= 0) {
            return allocations;
        }
        for (Map.Entry<ReservationInterval, Resource> tempAllocation : allocations.entrySet()) {
            planModifications.removeInterval(tempAllocation.getKey(), tempAllocation.getValue());
        }
        return null;
    }

    private List<Long> computeIntervalEndTimes(long stageEarliestStart, long stageDeadline, long duration) {
        ArrayList<Long> intervalEndTimes = new ArrayList<Long>();
        if (!this.allocateLeft) {
            for (long intervalEnd = stageDeadline; intervalEnd >= stageEarliestStart + duration; intervalEnd -= duration) {
                intervalEndTimes.add(intervalEnd);
            }
        } else {
            for (long intervalStart = stageEarliestStart; intervalStart <= stageDeadline - duration; intervalStart += duration) {
                intervalEndTimes.add(intervalStart + duration);
            }
        }
        return intervalEndTimes;
    }

    protected static DurationInterval getDurationInterval(long startTime, long endTime, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications, Resource capacity, RLESparseResourceAllocation netRLERes, ResourceCalculator resCalc, long step, Resource requestedResources) throws PlanningException {
        double totalCost = StageAllocatorLowCostAligned.getDurationIntervalTotalCost(startTime, endTime, planLoads, planModifications, capacity, resCalc, step);
        int gangsCanFit = StageAllocatorLowCostAligned.getDurationIntervalGangsCanFit(startTime, endTime, planModifications, capacity, netRLERes, resCalc, requestedResources);
        return new DurationInterval(startTime, endTime, totalCost, gangsCanFit);
    }

    protected static double getDurationIntervalTotalCost(long startTime, long endTime, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc, long step) throws PlanningException {
        RLESparseResourceAllocation currentLoad = RLESparseResourceAllocation.merge(resCalc, capacity, planLoads, planModifications, RLESparseResourceAllocation.RLEOperator.add, startTime, endTime);
        NavigableMap<Long, Resource> mapCurrentLoad = currentLoad.getCumulative();
        double totalCost = 0.0;
        Long tPrev = -1L;
        Resource loadPrev = Resources.none();
        double cost = 0.0;
        for (Map.Entry e : mapCurrentLoad.entrySet()) {
            Long t = (Long)e.getKey();
            Resource load = (Resource)e.getValue();
            if (tPrev != -1L) {
                tPrev = Math.max(tPrev, startTime);
                cost = StageAllocatorLowCostAligned.calcCostOfLoad(loadPrev, capacity, resCalc);
                totalCost += cost * (double)(t - tPrev) / (double)step;
            }
            tPrev = t;
            loadPrev = load;
        }
        if (loadPrev != null) {
            tPrev = Math.max(tPrev, startTime);
            cost = StageAllocatorLowCostAligned.calcCostOfLoad(loadPrev, capacity, resCalc);
            totalCost += cost * (double)(endTime - tPrev) / (double)step;
        }
        return totalCost;
    }

    protected static int getDurationIntervalGangsCanFit(long startTime, long endTime, RLESparseResourceAllocation planModifications, Resource capacity, RLESparseResourceAllocation netRLERes, ResourceCalculator resCalc, Resource requestedResources) throws PlanningException {
        int gangsCanFit = Integer.MAX_VALUE;
        RLESparseResourceAllocation netAvailableResources = RLESparseResourceAllocation.merge(resCalc, capacity, netRLERes, planModifications, RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, startTime, endTime);
        NavigableMap<Long, Resource> mapAvailableCapacity = netAvailableResources.getCumulative();
        for (Map.Entry e : mapAvailableCapacity.entrySet()) {
            Long t = (Long)e.getKey();
            Resource curAvailable = (Resource)e.getValue();
            if (t >= endTime) break;
            if (curAvailable == null) {
                gangsCanFit = 0;
                continue;
            }
            int curGangsCanFit = (int)Math.floor(Resources.divide((ResourceCalculator)resCalc, (Resource)capacity, (Resource)curAvailable, (Resource)requestedResources));
            if (curGangsCanFit >= gangsCanFit) continue;
            gangsCanFit = curGangsCanFit;
        }
        return gangsCanFit;
    }

    protected double calcCostOfInterval(long startTime, long endTime, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc, long step) {
        double totalCost = 0.0;
        for (long t = startTime; t < endTime; t += step) {
            totalCost += this.calcCostOfTimeSlot(t, planLoads, planModifications, capacity, resCalc);
        }
        return totalCost;
    }

    protected double calcCostOfTimeSlot(long t, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc) {
        Resource load = this.getLoadAtTime(t, planLoads, planModifications);
        return StageAllocatorLowCostAligned.calcCostOfLoad(load, capacity, resCalc);
    }

    protected Resource getLoadAtTime(long t, RLESparseResourceAllocation planLoads, RLESparseResourceAllocation planModifications) {
        Resource planLoad = planLoads.getCapacityAtTime(t);
        return Resources.add((Resource)planLoad, (Resource)planModifications.getCapacityAtTime(t));
    }

    protected static double calcCostOfLoad(Resource load, Resource capacity, ResourceCalculator resCalc) {
        return resCalc.ratio(load, capacity);
    }

    protected static long stepRoundDown(long t, long step) {
        return t / step * step;
    }

    protected static long stepRoundUp(long t, long step) {
        return (t + step - 1L) / step * step;
    }

    protected static class DurationInterval {
        private long startTime;
        private long endTime;
        private double cost;
        private final int gangsCanFit;

        public DurationInterval(long startTime, long endTime, double cost, int gangsCanfit) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.cost = cost;
            this.gangsCanFit = gangsCanfit;
        }

        public boolean canAllocate() {
            return this.gangsCanFit > 0;
        }

        public int numCanFit() {
            return this.gangsCanFit;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long value) {
            this.startTime = value;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long value) {
            this.endTime = value;
        }

        public double getTotalCost() {
            return this.cost;
        }

        public void setTotalCost(double value) {
            this.cost = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" start: " + this.startTime).append(" end: " + this.endTime).append(" cost: " + this.cost).append(" gangsCanFit: " + this.gangsCanFit);
            return sb.toString();
        }
    }
}

