/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued;

import io.hops.hadoop.shaded.com.sun.jersey.api.container.ContainerException;
import io.hops.hadoop.shaded.com.sun.jersey.core.header.HttpDateFormat;
import io.hops.hadoop.shaded.com.sun.jersey.core.reflection.ReflectionHelper;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import io.hops.hadoop.shaded.com.sun.jersey.spi.StringReader;
import io.hops.hadoop.shaded.com.sun.jersey.spi.StringReaderProvider;
import io.hops.hadoop.shaded.javax.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.text.ParseException;
import java.util.Date;

public class StringReaderProviders {

    public static class DateProvider
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (type != Date.class) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String value) {
                    try {
                        return HttpDateFormat.readDate((String)value);
                    }
                    catch (ParseException ex) {
                        throw new ExtractorContainerException(ex);
                    }
                }
            };
        }
    }

    public static class TypeFromStringEnum
    extends TypeFromString {
        @Override
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            return super.getStringReader(type, genericType, annotations);
        }
    }

    public static class TypeFromString
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            final Method fromString = (Method)AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA((Class)type));
            if (fromString == null) {
                return null;
            }
            return new AbstractStringReader(){

                @Override
                public Object _fromString(String value) throws Exception {
                    return fromString.invoke(null, value);
                }
            };
        }
    }

    public static class TypeValueOf
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            final Method valueOf = (Method)AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA((Class)type));
            if (valueOf == null) {
                return null;
            }
            return new AbstractStringReader(){

                @Override
                public Object _fromString(String value) throws Exception {
                    return valueOf.invoke(null, value);
                }
            };
        }
    }

    public static class StringConstructor
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            final Constructor constructor = (Constructor)AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA((Class)type));
            if (constructor == null) {
                return null;
            }
            return new AbstractStringReader(){

                @Override
                protected Object _fromString(String value) throws Exception {
                    return constructor.newInstance(value);
                }
            };
        }
    }

    private static abstract class AbstractStringReader
    implements StringReader {
        private AbstractStringReader() {
        }

        public Object fromString(String value) {
            try {
                return this._fromString(value);
            }
            catch (InvocationTargetException ex) {
                if (value.length() == 0) {
                    return null;
                }
                Throwable target = ex.getTargetException();
                if (target instanceof WebApplicationException) {
                    throw (WebApplicationException)target;
                }
                throw new ExtractorContainerException(target);
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }

        protected abstract Object _fromString(String var1) throws Exception;
    }
}

