/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileSnap;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Test;

public class EmptySnapshotTest {
    @Test
    public void testNoEmptySnapshot() throws Exception {
        File tmpFile = File.createTempFile("empty-snapshot-test", ".junit", new File(System.getProperty("build.test.dir", "build")));
        File tmpDataDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDataDir.exists());
        Assert.assertTrue((boolean)tmpDataDir.mkdirs());
        FileTxnSnapLog snapLog = new FileTxnSnapLog(tmpDataDir, tmpDataDir);
        snapLog.snapLog = new MockFileSnap(snapLog.dataDir);
        Assert.assertEquals((long)0L, (long)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
        DataTree tree = new DataTree();
        tree.createNode("/empty-snapshot-test-1", "data".getBytes(), null, -1L, -1, 1L, 1L);
        try {
            snapLog.save(tree, new ConcurrentHashMap<Long, Integer>(), false);
            Assert.fail((String)"Should have thrown an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
        snapLog.snapLog = new FileSnap(snapLog.dataDir);
        snapLog.save(tree, new ConcurrentHashMap<Long, Integer>(), false);
        Assert.assertEquals((long)1L, (long)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
    }

    static class MockFileSnap
    extends FileSnap {
        MockFileSnap(File snapDir) {
            super(snapDir);
        }

        @Override
        public synchronized void serialize(DataTree dt, Map<Long, Integer> sessions, File snapShot, boolean fsync) throws IOException {
            Assert.assertTrue((boolean)snapShot.createNewFile());
            throw new IOException("Created empty snapshot file from MockFileSnap::serialize()");
        }
    }
}

