/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.offheapstore.storage;

import io.hops.hadoop.shaded.org.terracotta.offheapstore.paging.OffHeapStorageArea;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.paging.PageSource;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.PointerSize;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.PortabilityBasedStorageEngine;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.StorageEngine;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.portability.Portability;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.portability.WriteContext;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.util.ByteBufferUtils;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.util.DebuggingUtils;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.util.Factory;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;

public class OffHeapBufferStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements OffHeapStorageArea.Owner {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int DATA_OFFSET = 12;
    private static final int HEADER_SIZE = 12;
    protected final OffHeapStorageArea storageArea;
    protected volatile StorageEngine.Owner owner;

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(width, source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, thief, victim);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)this, source, initialPageSize, maximalPageSize, thief, victim);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(width, this, source, initialPageSize, maximalPageSize, thief, victim, compressThreshold);
    }

    @Override
    protected void clearInternal() {
        this.storageArea.clear();
    }

    @Override
    protected void free(long address) {
        this.storageArea.free(address);
    }

    @Override
    public ByteBuffer readKeyBuffer(long address) {
        int length = this.storageArea.readInt(address + 4L);
        return this.storageArea.readBuffer(address + 12L, length).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getKeyWriteContext(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        return this.getWriteContext(address + 12L, keyLength);
    }

    @Override
    public ByteBuffer readValueBuffer(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return this.storageArea.readBuffer(address + 12L + (long)keyLength, valueLength).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getValueWriteContext(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return this.getWriteContext(address + 12L + (long)keyLength, valueLength);
    }

    private WriteContext getWriteContext(final long address, final int max) {
        return new WriteContext(){

            @Override
            public void setLong(int offset, long value) {
                if (offset < 0 || offset > max) {
                    throw new IllegalArgumentException();
                }
                OffHeapBufferStorageEngine.this.storageArea.writeLong(address + (long)offset, value);
            }

            @Override
            public void flush() {
            }
        };
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        int valueLength;
        int keyLength = keyBuffer.remaining();
        long address = this.storageArea.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
        if (address >= 0L) {
            this.storageArea.writeInt(address + 0L, hash);
            this.storageArea.writeInt(address + 4L, keyLength);
            this.storageArea.writeInt(address + 8L, valueLength);
            this.storageArea.writeBuffer(address + 12L, keyBuffer);
            this.storageArea.writeBuffer(address + 12L + (long)keyLength, valueBuffer);
            return address;
        }
        return null;
    }

    @Override
    protected Long writeMappingBuffersGathering(ByteBuffer[] keyBuffers, ByteBuffer[] valueBuffers, int hash) {
        int valueLength;
        int keyLength = ByteBufferUtils.totalLength(keyBuffers);
        long address = this.storageArea.allocate(keyLength + (valueLength = ByteBufferUtils.totalLength(valueBuffers)) + 12);
        if (address >= 0L) {
            this.storageArea.writeInt(address + 0L, hash);
            this.storageArea.writeInt(address + 4L, keyLength);
            this.storageArea.writeInt(address + 8L, valueLength);
            this.storageArea.writeBuffers(address + 12L, keyBuffers);
            this.storageArea.writeBuffers(address + 12L + (long)keyLength, valueBuffers);
            return address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    @Override
    public long getVitalMemory() {
        return this.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        return this.getOccupiedMemory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OffHeapBufferStorageEngine ");
        sb.append("allocated=").append(DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory())).append("B ");
        sb.append("occupied=").append(DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory())).append("B\n");
        sb.append("Storage Area: ").append(this.storageArea);
        return sb.toString();
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public boolean evictAtAddress(long address, boolean shrink) {
        int hash = this.storageArea.readInt(address + 0L);
        int slot = this.owner.getSlotForHashAndEncoding(hash, address, -1L);
        return this.owner.evict(slot, shrink);
    }

    @Override
    public boolean isThief() {
        return this.owner.isThiefForTableAllocations();
    }

    @Override
    public int readKeyHash(long encoding) {
        return this.storageArea.readInt(encoding + 0L);
    }

    @Override
    public boolean moved(long from, long to) {
        return this.owner.updateEncoding(this.readKeyHash(to), from, to, -1L);
    }

    @Override
    public int sizeOf(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return 12 + keyLength + valueLength;
    }

    @Override
    public void bind(StorageEngine.Owner m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = m;
    }

    @Override
    public Lock writeLock() {
        return this.owner.writeLock();
    }
}

