/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.metric;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounterSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvgMinMaxPercentileCounterSetTest
extends ZKTestCase {
    private AvgMinMaxPercentileCounterSet testCounterSet;

    @Before
    public void initCounter() {
        this.testCounterSet = new AvgMinMaxPercentileCounterSet("test");
    }

    private void addDataPoints() {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.testCounterSet.add("key1", (long)i);
        }
        for (i = 1000; i < 2000; ++i) {
            this.testCounterSet.add("key2", (long)i);
        }
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounterSet.reset();
        Map<String, Object> values = this.testCounterSet.values();
        Assert.assertEquals((String)"avg_key1_test should =0", (Object)0.0, (Object)values.get("avg_key1_test"));
        Assert.assertEquals((String)"min_key1_test should =0", (Object)0L, (Object)values.get("min_key1_test"));
        Assert.assertEquals((String)"max_key1_test should =0", (Object)0L, (Object)values.get("max_key1_test"));
        Assert.assertEquals((String)"cnt_key1_test should =0", (Object)0L, (Object)values.get("cnt_key1_test"));
        Assert.assertEquals((String)"sum_key1_test should =0", (Object)0L, (Object)values.get("sum_key1_test"));
        Assert.assertEquals((String)"p50_key1_test should have p50=0", (Object)0L, (Object)values.get("p50_key1_test"));
        Assert.assertEquals((String)"p95_key1_test should have p95=0", (Object)0L, (Object)values.get("p95_key1_test"));
        Assert.assertEquals((String)"p99_key1_test should have p99=0", (Object)0L, (Object)values.get("p99_key1_test"));
        Assert.assertEquals((String)"p999_key1_test should have p999=0", (Object)0L, (Object)values.get("p999_key1_test"));
        Assert.assertEquals((String)"avg_key2_test should =0", (Object)0.0, (Object)values.get("avg_key2_test"));
        Assert.assertEquals((String)"min_key2_test should =0", (Object)0L, (Object)values.get("min_key2_test"));
        Assert.assertEquals((String)"max_key2_test should =0", (Object)0L, (Object)values.get("max_key2_test"));
        Assert.assertEquals((String)"cnt_key2_test should =0", (Object)0L, (Object)values.get("cnt_key2_test"));
        Assert.assertEquals((String)"sum_key2_test should =0", (Object)0L, (Object)values.get("sum_key2_test"));
        Assert.assertEquals((String)"p50_key2_test should have p50=0", (Object)0L, (Object)values.get("p50_key2_test"));
        Assert.assertEquals((String)"p95_key2_test should have p95=0", (Object)0L, (Object)values.get("p95_key2_test"));
        Assert.assertEquals((String)"p99_key2_test should have p99=0", (Object)0L, (Object)values.get("p99_key2_test"));
        Assert.assertEquals((String)"p999_key2_test should have p999=0", (Object)0L, (Object)values.get("p999_key2_test"));
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map<String, Object> values = this.testCounterSet.values();
        Assert.assertEquals((String)"There should be 18 values in the set", (long)18L, (long)values.size());
        Assert.assertEquals((String)"avg_key1_test should =499.5", (Object)499.5, (Object)values.get("avg_key1_test"));
        Assert.assertEquals((String)"min_key1_test should =0", (Object)0L, (Object)values.get("min_key1_test"));
        Assert.assertEquals((String)"max_key1_test should =999", (Object)999L, (Object)values.get("max_key1_test"));
        Assert.assertEquals((String)"cnt_key1_test should =1000", (Object)1000L, (Object)values.get("cnt_key1_test"));
        Assert.assertEquals((String)"sum_key1_test should =999*500", (Object)499500L, (Object)values.get("sum_key1_test"));
        Assert.assertEquals((String)"p50_key1_test should have p50=500", (Object)500L, (Object)values.get("p50_key1_test"));
        Assert.assertEquals((String)"p95_key1_test should have p95=950", (Object)950L, (Object)values.get("p95_key1_test"));
        Assert.assertEquals((String)"p99_key1_test should have p99=990", (Object)990L, (Object)values.get("p99_key1_test"));
        Assert.assertEquals((String)"p999_key1_test should have p999=999", (Object)999L, (Object)values.get("p999_key1_test"));
        Assert.assertEquals((String)"avg_key2_test should =3.5", (Object)1499.5, (Object)values.get("avg_key2_test"));
        Assert.assertEquals((String)"min_key2_test should =2", (Object)1000L, (Object)values.get("min_key2_test"));
        Assert.assertEquals((String)"max_key2_test should =5", (Object)1999L, (Object)values.get("max_key2_test"));
        Assert.assertEquals((String)"cnt_key2_test should =4", (Object)1000L, (Object)values.get("cnt_key2_test"));
        Assert.assertEquals((String)"sum_key2_test should =14", (Object)1499500L, (Object)values.get("sum_key2_test"));
        Assert.assertEquals((String)"p50_key2_test should have p50=1500", (Object)1500L, (Object)values.get("p50_key2_test"));
        Assert.assertEquals((String)"p95_key2_test should have p95=1950", (Object)1950L, (Object)values.get("p95_key2_test"));
        Assert.assertEquals((String)"p99_key2_test should have p99=1990", (Object)1990L, (Object)values.get("p99_key2_test"));
        Assert.assertEquals((String)"p999_key2_test should have p999=1999", (Object)1999L, (Object)values.get("p999_key2_test"));
    }
}

