/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ExitCode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Learner;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.MultipleAddresses;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.TestUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.util.ServiceUtils;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LearnerTest
extends ZKTestCase {
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));

    @After
    public void cleanup() {
        System.clearProperty("zookeeper.multiAddress.enabled");
    }

    @Test(expected=IOException.class)
    public void connectionRetryTimeoutTest() throws Exception {
        TestLearner learner = new TestLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addr = new InetSocketAddress(1111);
        learner.connectToLeader(new MultipleAddresses(addr), "");
    }

    @Test
    public void connectionInitLimitTimeoutTest() throws Exception {
        TestLearner learner = new TestLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addr = new InetSocketAddress(1111);
        learner.setTimeMultiplier(4000000000L);
        learner.setPassConnectAttempt(5);
        try {
            learner.connectToLeader(new MultipleAddresses(addr), "");
            Assert.fail((String)"should have thrown IOException!");
        }
        catch (IOException e) {
            Assert.assertTrue((learner.nanoTime() > 1410065408L ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)learner.getSockConnectAttempt());
        }
    }

    @Test
    public void shouldTryMultipleAddresses() throws Exception {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        TestLearner learner = new TestLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addrA = new InetSocketAddress(1111);
        InetSocketAddress addrB = new InetSocketAddress(2222);
        InetSocketAddress addrC = new InetSocketAddress(3333);
        InetSocketAddress addrD = new InetSocketAddress(4444);
        learner.setPassConnectAttempt(100);
        try {
            learner.connectToLeader(new MultipleAddresses(Arrays.asList(addrA, addrB, addrC, addrD)), "");
            Assert.fail((String)"should have thrown IOException!");
        }
        catch (IOException e) {
            Assert.assertEquals((long)20L, (long)learner.getSockConnectAttempt());
        }
    }

    @Test
    public void multipleAddressesSomeAreFailing() throws Exception {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        TestLearner learner = new TestLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addrWorking = new InetSocketAddress(1111);
        InetSocketAddress addrBadA = new InetSocketAddress(2222);
        InetSocketAddress addrBadB = new InetSocketAddress(3333);
        InetSocketAddress addrBadC = new InetSocketAddress(4444);
        learner.setUnreachableAddresses(new HashSet<InetSocketAddress>(Arrays.asList(addrBadA, addrBadB, addrBadC)));
        learner.setPassConnectAttempt(0);
        Socket mockSocket = Mockito.mock(Socket.class);
        Mockito.when(mockSocket.isConnected()).thenReturn(true);
        learner.setSocketToBeCreated(mockSocket);
        learner.connectToLeader(new MultipleAddresses(Arrays.asList(addrBadA, addrBadB, addrBadC, addrWorking)), "");
        Assert.assertEquals((String)"Learner connected to the wrong address", (Object)learner.getSocket(), (Object)mockSocket);
    }

    @Test
    public void connectToLearnerMasterLimitTest() throws Exception {
        TestLearner learner = new TestLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(2);
        learner.self.setSyncLimit(2);
        learner.self.setConnectToLearnerMasterLimit(5);
        InetSocketAddress addr = new InetSocketAddress(1111);
        learner.setTimeMultiplier(4000000000L);
        learner.setPassConnectAttempt(5);
        try {
            learner.connectToLeader(new MultipleAddresses(addr), "");
            Assert.fail((String)"should have thrown IOException!");
        }
        catch (IOException e) {
            Assert.assertTrue((learner.nanoTime() > 1410065408L ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)learner.getSockConnectAttempt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void syncTest() throws Exception {
        File tmpFile = File.createTempFile("test", ".dir", testData);
        tmpFile.delete();
        try {
            FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpFile, tmpFile);
            SimpleLearner sl = new SimpleLearner(ftsl);
            long startZxid = sl.zk.getLastProcessedZxid();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive(baos);
            sl.leaderOs = BinaryOutputArchive.getArchive(new ByteArrayOutputStream());
            sl.bufferedOutput = new BufferedOutputStream(System.out);
            sl.sock = new Socket();
            QuorumPacket qp = new QuorumPacket(15, 0L, null, null);
            oa.writeRecord(qp, null);
            sl.zk.getZKDatabase().serializeSnapshot(oa);
            oa.writeString("BenWasHere", "signature");
            TxnHeader hdr = new TxnHeader(0L, 0, 0L, 0L, 1);
            CreateTxn txn = new CreateTxn("/foo", new byte[0], new ArrayList<ACL>(), false, sl.zk.getZKDatabase().getNode((String)"/").stat.getCversion());
            ByteArrayOutputStream tbaos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(tbaos);
            hdr.serialize(boa, "hdr");
            txn.serialize(boa, "txn");
            tbaos.close();
            qp = new QuorumPacket(2, 1L, tbaos.toByteArray(), null);
            oa.writeRecord(qp, null);
            sl.leaderIs = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
            try {
                sl.syncWithLeader(3L);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            sl.zk.shutdown();
            sl = new SimpleLearner(ftsl);
            Assert.assertEquals((long)startZxid, (long)sl.zk.getLastProcessedZxid());
        }
        finally {
            TestUtils.deleteFileRecursively((File)tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void truncFailTest() throws Exception {
        final boolean[] exitProcCalled = new boolean[]{false};
        ServiceUtils.setSystemExitProcedure(new Consumer<Integer>(){

            @Override
            public void accept(Integer exitCode) {
                exitProcCalled[0] = true;
                Assert.assertThat((String)"System.exit() was called with invalid exit code", (Object)exitCode, CoreMatchers.equalTo(ExitCode.QUORUM_PACKET_ERROR.getValue()));
            }
        });
        File tmpFile = File.createTempFile("test", ".dir", testData);
        tmpFile.delete();
        try {
            FileTxnSnapLog txnSnapLog = new FileTxnSnapLog(tmpFile, tmpFile);
            SimpleLearner sl = new SimpleLearner(txnSnapLog);
            long startZxid = sl.zk.getLastProcessedZxid();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive(baos);
            sl.leaderOs = BinaryOutputArchive.getArchive(new ByteArrayOutputStream());
            sl.bufferedOutput = new BufferedOutputStream(System.out);
            sl.sock = new Socket();
            QuorumPacket qp = new QuorumPacket(14, 0L, null, null);
            oa.writeRecord(qp, null);
            sl.leaderIs = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
            try {
                sl.syncWithLeader(3L);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            sl.zk.shutdown();
            Assert.assertThat((String)"System.exit() should have been called", (Object)exitProcCalled[0], CoreMatchers.is(true));
        }
        finally {
            TestUtils.deleteFileRecursively((File)tmpFile);
        }
    }

    static class TestLearner
    extends Learner {
        private int passSocketConnectOnAttempt = 10;
        private int socketConnectAttempt = 0;
        private long timeMultiplier = 0L;
        private Socket socketToBeCreated = null;
        private Set<InetSocketAddress> unreachableAddresses = Collections.emptySet();

        TestLearner() {
        }

        private void setTimeMultiplier(long multiplier) {
            this.timeMultiplier = multiplier;
        }

        private void setPassConnectAttempt(int num) {
            this.passSocketConnectOnAttempt = num;
        }

        @Override
        protected long nanoTime() {
            return (long)this.socketConnectAttempt * this.timeMultiplier;
        }

        private int getSockConnectAttempt() {
            return this.socketConnectAttempt;
        }

        private void setSocketToBeCreated(Socket socketToBeCreated) {
            this.socketToBeCreated = socketToBeCreated;
        }

        private void setUnreachableAddresses(Set<InetSocketAddress> unreachableAddresses) {
            this.unreachableAddresses = unreachableAddresses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sockConnect(Socket sock, InetSocketAddress addr, int timeout) throws IOException {
            TestLearner testLearner = this;
            synchronized (testLearner) {
                if (++this.socketConnectAttempt < this.passSocketConnectOnAttempt || this.unreachableAddresses.contains(addr)) {
                    throw new IOException("Test injected Socket.connect() error.");
                }
            }
        }

        @Override
        protected Socket createSocket() throws X509Exception, IOException {
            if (this.socketToBeCreated != null) {
                return this.socketToBeCreated;
            }
            return super.createSocket();
        }
    }

    static class SimpleLearner
    extends Learner {
        SimpleLearner(FileTxnSnapLog ftsl) throws IOException {
            this.self = new QuorumPeer();
            this.zk = new SimpleLearnerZooKeeperServer(ftsl, this.self);
            ((SimpleLearnerZooKeeperServer)this.zk).learner = this;
        }
    }

    static class SimpleLearnerZooKeeperServer
    extends LearnerZooKeeperServer {
        Learner learner;

        public SimpleLearnerZooKeeperServer(FileTxnSnapLog ftsl, QuorumPeer self) throws IOException {
            super(ftsl, 2000, 2000, 2000, -1, new ZKDatabase(ftsl), self);
        }

        @Override
        public Learner getLearner() {
            return this.learner;
        }
    }
}

