/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.QuorumAuthTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientTest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class QuorumAuthUpgradeTest
extends QuorumAuthTestBase {
    @Override
    @After
    public void tearDown() throws Exception {
        this.shutdownAll();
        super.tearDown();
    }

    @AfterClass
    public static void cleanup() {
        QuorumAuthUpgradeTest.cleanupJaasConfig();
    }

    @Test(timeout=30000L)
    public void testNullAuthLearnerServer() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "false");
        String connectStr = this.startQuorum(2, authConfigs, 0);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
    }

    @Test(timeout=30000L)
    public void testAuthLearnerAgainstNullAuthServer() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        String connectStr = this.startQuorum(2, authConfigs, 1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
    }

    @Test(timeout=30000L)
    public void testAuthLearnerAgainstNoAuthRequiredServer() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        String connectStr = this.startQuorum(2, authConfigs, 2);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
    }

    @Test(timeout=30000L)
    public void testAuthLearnerServer() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        String connectStr = this.startQuorum(2, authConfigs, 2);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
    }

    @Test(timeout=90000L)
    public void testRollingUpgrade() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "false");
        String connectStr = this.startQuorum(3, authConfigs, 0);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        authConfigs.put("quorum.auth.learnerRequireSasl", "false");
        this.restartServer(authConfigs, 0, zk, watcher);
        this.restartServer(authConfigs, 1, zk, watcher);
        this.restartServer(authConfigs, 2, zk, watcher);
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        this.restartServer(authConfigs, 0, zk, watcher);
        this.restartServer(authConfigs, 1, zk, watcher);
        this.restartServer(authConfigs, 2, zk, watcher);
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        this.restartServer(authConfigs, 0, zk, watcher);
        this.restartServer(authConfigs, 1, zk, watcher);
        this.restartServer(authConfigs, 2, zk, watcher);
        authConfigs.put("quorum.auth.enableSasl", "false");
        QuorumPeerTestBase.MainThread m = this.shutdown(2);
        this.startServer(m, authConfigs);
        Assert.assertFalse((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + m.getClientPort(), 5000L));
    }

    private void restartServer(Map<String, String> authConfigs, int index, ZooKeeper zk, ClientBase.CountdownWatcher watcher) throws IOException, KeeperException, InterruptedException, TimeoutException {
        LOG.info("Restarting server myid={}", (Object)index);
        QuorumPeerTestBase.MainThread m = this.shutdown(index);
        this.startServer(m, authConfigs);
        Assert.assertTrue((String)("waiting for server" + index + "being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + m.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
        watcher.waitForConnected(ClientTest.CONNECTION_TIMEOUT);
        zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    static {
        String jaasEntries = "QuorumServer {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       user_test=\"mypassword\";\n};\nQuorumLearner {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"mypassword\";\n};\n";
        QuorumAuthUpgradeTest.setupJaasConfig(jaasEntries);
    }
}

