/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.admin.AdminServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Follower;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Learner;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ReconfigDuringLeaderSyncTest
extends QuorumPeerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigDuringLeaderSyncTest.class);
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt;
    private static boolean bakAsyncSending;
    private boolean asyncSending;

    public ReconfigDuringLeaderSyncTest(boolean asyncSending) {
        this.asyncSending = asyncSending;
    }

    @Parameterized.Parameters
    public static Collection sendingModes() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        Learner.setAsyncSending(this.asyncSending);
        QuorumPeerConfig.setReconfigEnabled(true);
    }

    @BeforeClass
    public static void saveAsyncSendingFlag() {
        bakAsyncSending = Learner.getAsyncSending();
    }

    @AfterClass
    public static void resetAsyncSendingFlag() {
        Learner.setAsyncSending(bakAsyncSending);
    }

    @Test
    public void testDuringLeaderSync() throws Exception {
        int i;
        int[] clientPorts = new int[SERVER_COUNT + 1];
        StringBuilder sb = new StringBuilder();
        String[] serverConfig = new String[SERVER_COUNT + 1];
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            serverConfig[i2] = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(serverConfig[i2] + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        this.mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT + 1];
        for (i = 0; i < SERVER_COUNT; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            this.mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        ClientBase.CountdownWatcher watch = new ClientBase.CountdownWatcher();
        ZooKeeperAdmin preReconfigClient = new ZooKeeperAdmin("127.0.0.1:" + clientPorts[0], ClientBase.CONNECTION_TIMEOUT, watch);
        preReconfigClient.addAuthInfo("digest", "super:test".getBytes());
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        int joinerId = SERVER_COUNT;
        clientPorts[joinerId] = PortAssignment.unique();
        serverConfig[joinerId] = "server." + joinerId + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[joinerId];
        int leaderId = -1;
        for (int i3 = 0; i3 < SERVER_COUNT; ++i3) {
            if (this.mt[i3].main.quorumPeer.leader == null) continue;
            leaderId = i3;
            break;
        }
        Assert.assertFalse((leaderId == -1 ? 1 : 0) != 0);
        sb = new StringBuilder();
        sb.append(serverConfig[leaderId] + "\n").append(serverConfig[joinerId] + "\n");
        this.mt[joinerId] = new QuorumPeerTestBase.MainThread(joinerId, clientPorts[joinerId], sb.toString(), false){

            @Override
            public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                return new MockTestQPMain();
            }
        };
        this.mt[joinerId].start();
        CustomQuorumPeer qp = ReconfigDuringLeaderSyncTest.getCustomQuorumPeer(this.mt[joinerId]);
        String nextDynamicConfigFilename = qp.getNextDynamicConfigFilename();
        File nextDynaFile = new File(nextDynamicConfigFilename);
        nextDynaFile.delete();
        while (true) {
            if (qp.isNewLeaderMessage()) break;
            Thread.sleep(10L);
        }
        preReconfigClient.reconfigure(serverConfig[joinerId], null, null, -1L, null, null);
        watch = new ClientBase.CountdownWatcher();
        ZooKeeper postReconfigClient = new ZooKeeper("127.0.0.1:" + clientPorts[joinerId], ClientBase.CONNECTION_TIMEOUT, watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        postReconfigClient.create("/reconfigIssue", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertFalse((String)"zoo.cfg.dynamic.next is not deleted.", (boolean)nextDynaFile.exists());
        for (long j = 0L; j <= (long)SERVER_COUNT; ++j) {
            Assert.assertNotNull((String)("server " + j + " is not present in the new quorum"), (Object)qp.getQuorumVerifier().getVotingMembers().get(j));
        }
        preReconfigClient.close();
        postReconfigClient.close();
    }

    private static CustomQuorumPeer getCustomQuorumPeer(QuorumPeerTestBase.MainThread mt) {
        QuorumPeer quorumPeer;
        while (null == (quorumPeer = mt.getQuorumPeer())) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return (CustomQuorumPeer)quorumPeer;
    }

    @Override
    @After
    public void tearDown() {
        if (null != this.mt) {
            for (int i = 0; i < this.mt.length; ++i) {
                try {
                    this.mt[i].shutdown();
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
                }
            }
        }
    }

    private static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        private MockTestQPMain() {
        }

        @Override
        public void runFromConfig(QuorumPeerConfig config) throws IOException, AdminServer.AdminServerException {
            this.quorumPeer = new CustomQuorumPeer(config.getQuorumVerifier().getAllMembers(), config.getDataDir(), config.getDataLogDir(), config.getClientPortAddress().getPort(), config.getElectionAlg(), config.getServerId(), config.getTickTime(), config.getInitLimit(), config.getSyncLimit(), config.getConnectToLearnerMasterLimit());
            this.quorumPeer.setConfigFileName(config.getConfigFilename());
            this.quorumPeer.start();
            try {
                this.quorumPeer.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Quorum Peer interrupted", (Throwable)e);
            }
        }
    }

    private static class CustomQuorumPeer
    extends QuorumPeer {
        private boolean newLeaderMessage = false;

        public CustomQuorumPeer(Map<Long, QuorumPeer.QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, int connectToLearnerMasterLimit) throws IOException {
            super(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, false, ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), -1), new QuorumMaj(quorumPeers));
        }

        public boolean isNewLeaderMessage() {
            return this.newLeaderMessage;
        }

        @Override
        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            return new Follower(this, new FollowerZooKeeperServer(logFactory, this, this.getZkDb())){

                @Override
                void writePacket(QuorumPacket pp, boolean flush) throws IOException {
                    if (pp != null && pp.getType() == 3) {
                        newLeaderMessage = true;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    super.writePacket(pp, flush);
                }
            };
        }
    }
}

