/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface CGroupsHandler {
    public static final String CGROUP_FILE_TASKS = "tasks";
    public static final String CGROUP_PARAM_CLASSID = "classid";
    public static final String CGROUP_PARAM_BLKIO_WEIGHT = "weight";
    public static final String CGROUP_PARAM_MEMORY_SWAP_HARD_LIMIT_BYTES = "memsw.limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_USAGE_BYTES = "usage_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_MEMSW_USAGE_BYTES = "memsw.usage_in_bytes";
    public static final String CGROUP_NO_LIMIT = "-1";

    public void initializeCGroupController(CGroupController var1) throws ResourceHandlerException;

    public String createCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public void deleteCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public String getControllerPath(CGroupController var1);

    public String getRelativePathForCGroup(String var1);

    public String getPathForCGroup(CGroupController var1, String var2);

    public String getPathForCGroupTasks(CGroupController var1, String var2);

    public String getPathForCGroupParam(CGroupController var1, String var2, String var3);

    public void updateCGroupParam(CGroupController var1, String var2, String var3, String var4) throws ResourceHandlerException;

    public String getCGroupParam(CGroupController var1, String var2, String var3) throws ResourceHandlerException;

    public String getCGroupMountPath();

    public static enum MemoryParameters {
        HARD_LIMIT_BYTES("limit_in_bytes"),
        SOFT_LIMIT_BYTES("soft_limit_in_bytes"),
        SWAPPINESS("swappiness"),
        OOM_CONTROL("oom_control"),
        MEMORY_MAX("max"),
        MEMORY_HIGH("high"),
        EVENTS_LOCAL("events.local");

        private final String name;

        private MemoryParameters(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    public static enum CpuParameters {
        PERIOD_US("cfs_period_us"),
        QUOTA_US("cfs_quota_us"),
        SHARES("shares"),
        MAX("max"),
        WEIGHT("weight");

        private final String name;

        private CpuParameters(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    public static enum CGroupController {
        CPU("cpu", CGroupVersion.V1V2),
        NET_CLS("net_cls", CGroupVersion.V1),
        BLKIO("blkio", CGroupVersion.V1),
        MEMORY("memory", CGroupVersion.V1V2),
        CPUACCT("cpuacct", CGroupVersion.V1),
        CPUSET("cpuset", CGroupVersion.V1V2),
        FREEZER("freezer", CGroupVersion.V1),
        DEVICES("devices", CGroupVersion.V1);

        private final String name;
        private final CGroupVersion cGroupVersion;
        public static final Function<CGroupController, Boolean> NO_CGROUP_FILTER;
        public static final Function<CGroupController, Boolean> V1_CGROUP_FILTER;

        private CGroupController(String name, CGroupVersion cGroupVersion) {
            this.name = name;
            this.cGroupVersion = cGroupVersion;
        }

        public String getName() {
            return this.name;
        }

        public CGroupVersion getcGroupVersion() {
            return this.cGroupVersion;
        }

        public static Set<String> getValidCGroups(Function<CGroupController, Boolean> filter) {
            HashSet<String> validCgroups = new HashSet<String>();
            for (CGroupController controller : CGroupController.values()) {
                if (!filter.apply(controller).booleanValue()) continue;
                validCgroups.add(controller.getName());
            }
            return validCgroups;
        }

        static {
            NO_CGROUP_FILTER = t -> true;
            V1_CGROUP_FILTER = t -> t.getcGroupVersion().equals((Object)CGroupVersion.V1) || t.getcGroupVersion().equals((Object)CGroupVersion.V1V2);
        }
    }

    public static enum CGroupVersion {
        V1,
        V2,
        V1V2;

    }
}

