/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerConfigTest {
    private ServerConfig serverConfig;

    @Before
    public void setUp() {
        this.serverConfig = new ServerConfig();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFewArguments() {
        String[] args = new String[]{"2181"};
        this.serverConfig.parse(args);
    }

    @Test
    public void testValidArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000"};
        this.serverConfig.parse(args);
        Assert.assertEquals((long)2181L, (long)this.serverConfig.getClientPortAddress().getPort());
        Assert.assertTrue((boolean)this.checkEquality("/data/dir", this.serverConfig.getDataDir()));
        Assert.assertEquals((long)60000L, (long)this.serverConfig.getTickTime());
        Assert.assertEquals((long)10000L, (long)this.serverConfig.getMaxClientCnxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTooManyArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000", "9999"};
        this.serverConfig.parse(args);
    }

    @Test
    public void testJvmPauseMonitorConfigured() {
        Long sleepTime = 444L;
        Long warnTH = 5555L;
        Long infoTH = 555L;
        QuorumPeerConfig qpConfig = Mockito.mock(QuorumPeerConfig.class);
        Mockito.when(qpConfig.isJvmPauseMonitorToRun()).thenReturn(true);
        Mockito.when(qpConfig.getJvmPauseSleepTimeMs()).thenReturn(sleepTime);
        Mockito.when(qpConfig.getJvmPauseWarnThresholdMs()).thenReturn(warnTH);
        Mockito.when(qpConfig.getJvmPauseInfoThresholdMs()).thenReturn(infoTH);
        this.serverConfig.readFrom(qpConfig);
        Assert.assertEquals((Object)sleepTime, (Object)this.serverConfig.getJvmPauseSleepTimeMs());
        Assert.assertEquals((Object)warnTH, (Object)this.serverConfig.getJvmPauseWarnThresholdMs());
        Assert.assertEquals((Object)infoTH, (Object)this.serverConfig.getJvmPauseInfoThresholdMs());
        Assert.assertTrue((boolean)this.serverConfig.isJvmPauseMonitorToRun());
    }

    boolean checkEquality(String a, String b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return a.equals(b);
    }

    boolean checkEquality(String a, File b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return new File(a).equals(b);
    }
}

