/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.JUnit4ZKTestRunner;
import io.hops.hadoop.shaded.org.apache.zookeeper.util.ServiceUtils;
import java.io.File;
import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4ZKTestRunner.class)
public class ZKTestCase {
    protected static final File testBaseDir = new File(System.getProperty("build.test.dir", "build"));
    private static final Logger LOG = LoggerFactory.getLogger(ZKTestCase.class);
    private String testName;
    @Rule
    public TestWatcher watchman = new TestWatcher(){

        public void starting(Description method) {
            System.setProperty("zookeeper.admin.enableServer", "false");
            System.setProperty("zookeeper.4lw.commands.whitelist", "*");
            ZKTestCase.this.testName = method.getMethodName();
            LOG.info("STARTING {}", (Object)ZKTestCase.this.testName);
        }

        public void finished(Description method) {
            LOG.info("FINISHED {}", (Object)ZKTestCase.this.testName);
        }

        public void succeeded(Description method) {
            LOG.info("SUCCEEDED {}", (Object)ZKTestCase.this.testName);
        }

        public void failed(Throwable e, Description method) {
            LOG.error("FAILED {}", (Object)ZKTestCase.this.testName, (Object)e);
        }
    };

    protected String getTestName() {
        return this.testName;
    }

    @BeforeClass
    public static void before() {
        if (!testBaseDir.exists()) {
            Assert.assertTrue((String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()), (boolean)testBaseDir.mkdirs());
        } else if (!testBaseDir.isDirectory()) {
            Assert.assertTrue((String)("Cannot properly delete file with duplicate name of test base directory " + testBaseDir.getAbsolutePath()), (boolean)testBaseDir.delete());
            Assert.assertTrue((String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()), (boolean)testBaseDir.mkdirs());
        }
    }

    public void waitFor(String msg, WaitForCondition condition, int timeout) throws InterruptedException {
        LocalDateTime deadline = LocalDateTime.now().plusSeconds(timeout);
        while (LocalDateTime.now().isBefore(deadline)) {
            if (condition.evaluate()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)msg);
    }

    static {
        ServiceUtils.setSystemExitProcedure(ServiceUtils.LOG_ONLY);
    }

    public static interface WaitForCondition {
        public boolean evaluate();
    }
}

