/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumCnxManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumCnxManagerSocketConnectionTimeoutTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumCnxManagerSocketConnectionTimeoutTest.class);
    private QuorumUtil qu;

    @Before
    public void setUp() throws Exception {
        this.qu = new QuorumUtil(1, 2);
        this.qu.startAll();
    }

    @Test
    public void testSocketConnectionTimeoutDuringConnectingToElectionAddress() throws Exception {
        int leaderId = this.qu.getLeaderServer();
        InetSocketAddress leaderElectionAddress = this.qu.getLeaderQuorumPeer().getElectionAddress().getOne();
        QuorumCnxManager.setSocketFactory(() -> new SocketStub(leaderElectionAddress));
        this.qu.shutdown(leaderId);
        Assert.assertTrue((String)"Timeout during waiting for current leader to go down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.qu.getPeer((int)leaderId).clientPort, ClientBase.CONNECTION_TIMEOUT));
        String errorMessage = "No new leader was elected";
        this.waitFor(errorMessage, () -> this.qu.leaderExists() && this.qu.getLeaderServer() != leaderId, 15);
    }

    @After
    public void tearDown() throws Exception {
        this.qu.shutdownAll();
        QuorumCnxManager.setSocketFactory(QuorumCnxManager.DEFAULT_SOCKET_FACTORY);
    }

    final class SocketStub
    extends Socket {
        private final InetSocketAddress addressToTimeout;

        SocketStub(InetSocketAddress addressToTimeout) {
            this.addressToTimeout = addressToTimeout;
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            if (this.addressToTimeout.equals(endpoint)) {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    LOG.warn("interrupted SocketStub.connect", (Throwable)e);
                }
                throw new SocketTimeoutException("timeout reached in SocketStub.connect()");
            }
            super.connect(endpoint, timeout);
        }
    }
}

