/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.common.IDsGeneratorFactory;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.Time;

class FSDirSymlinkOp {
    FSDirSymlinkOp() {
    }

    static HdfsFileStatus createSymlinkInt(final FSNamesystem fsn, final String target, String linkArg, final PermissionStatus dirPerms, final boolean createParent) throws IOException {
        final FSDirectory fsd = fsn.getFSDirectory();
        if (!DFSUtil.isValidName(linkArg)) {
            throw new InvalidPathException("Invalid link name: " + linkArg);
        }
        if (FSDirectory.isReservedName(target) || target.isEmpty()) {
            throw new InvalidPathException("Invalid target name: " + target);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.createSymlink: target=" + target + " link=" + linkArg);
        }
        final FSPermissionChecker pc = fsn.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(linkArg);
        final String link = fsd.resolvePath(pc, linkArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.CREATE_SYM_LINK, link){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, link).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getAcesLock());
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                locks.add(lf.getEZLock());
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO);
                xAttrsToLock.add(FSDirXAttrOp.XATTR_ENCRYPTION_ZONE);
                locks.add(lf.getXAttrLock(xAttrsToLock));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    INodesInPath iip = fsd.getINodesInPath4Write(link, false);
                    if (!createParent) {
                        fsd.verifyParentDir(iip, link);
                    }
                    if (!fsd.isValidToCreate(link, iip)) {
                        throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
                    }
                    if (fsd.isPermissionEnabled()) {
                        fsd.checkAncestorAccess(pc, iip, FsAction.WRITE);
                    }
                    fsn.checkFsObjectLimit();
                    FSDirSymlinkOp.addSymlink(fsd, link, iip, target, dirPerms, createParent);
                    NameNode.getNameNodeMetrics().incrCreateSymlinkOps();
                    success = true;
                    HdfsFileStatus hdfsFileStatus = fsd.getAuditFileInfo(iip);
                    return hdfsFileStatus;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
            }
        }.handle();
    }

    static INodeSymlink unprotectedAddSymlink(FSDirectory fsd, INodesInPath iip, byte[] localName, long id, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException, IOException {
        INodeSymlink symlink = new INodeSymlink(id, target, mtime, atime, perm);
        symlink.setLocalNameNoPersistance(localName);
        return fsd.addINode(iip, symlink) != null ? symlink : null;
    }

    private static INodeSymlink addSymlink(FSDirectory fsd, String path, INodesInPath iip, String target, PermissionStatus dirPerms, boolean createParent) throws IOException {
        long mtime = Time.now();
        byte[] localName = iip.getLastLocalName();
        if (createParent) {
            Map.Entry<INodesInPath, String> e = FSDirMkdirOp.createAncestorDirectories(fsd, iip, dirPerms);
            if (e == null) {
                return null;
            }
            iip = INodesInPath.append(e.getKey(), null, localName);
        }
        String userName = dirPerms.getUserName();
        long id = IDsGeneratorFactory.getInstance().getUniqueINodeID();
        PermissionStatus perm = new PermissionStatus(userName, null, FsPermission.getDefault());
        INodeSymlink newNode = FSDirSymlinkOp.unprotectedAddSymlink(fsd, iip.getExistingINodes(), localName, id, target, mtime, mtime, perm);
        if (newNode == null) {
            NameNode.stateChangeLog.info("addSymlink: failed to add " + path);
            return null;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("addSymlink: " + path + " is added");
        }
        return newNode;
    }
}

