/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.util.Records;

public abstract class UpdatedCryptoForApp {
    public static UpdatedCryptoForApp newInstance(ByteBuffer keyStore, char[] keyStorePassword, ByteBuffer trustStore, char[] trustStorePassword, int version) {
        UpdatedCryptoForApp updatedCryptoForApp = (UpdatedCryptoForApp)Records.newRecord(UpdatedCryptoForApp.class);
        updatedCryptoForApp.setKeyStore(keyStore);
        updatedCryptoForApp.setKeyStorePassword(keyStorePassword);
        updatedCryptoForApp.setTrustStore(trustStore);
        updatedCryptoForApp.setTrustStorePassword(trustStorePassword);
        updatedCryptoForApp.setVersion(version);
        return updatedCryptoForApp;
    }

    public static UpdatedCryptoForApp newInstance(int x509Version, long jwtExpiration) {
        UpdatedCryptoForApp updatedCryptoForApp = (UpdatedCryptoForApp)Records.newRecord(UpdatedCryptoForApp.class);
        updatedCryptoForApp.setVersion(x509Version);
        updatedCryptoForApp.setJWTExpiration(jwtExpiration);
        return updatedCryptoForApp;
    }

    public abstract ByteBuffer getKeyStore();

    public abstract void setKeyStore(ByteBuffer var1);

    public abstract char[] getKeyStorePassword();

    public abstract void setKeyStorePassword(char[] var1);

    public abstract ByteBuffer getTrustStore();

    public abstract void setTrustStore(ByteBuffer var1);

    public abstract char[] getTrustStorePassword();

    public abstract void setTrustStorePassword(char[] var1);

    public abstract int getVersion();

    public abstract void setVersion(int var1);

    public abstract String getJWT();

    public abstract void setJWT(String var1);

    public abstract long getJWTExpiration();

    public abstract void setJWTExpiration(long var1);

    public UPDATE_TYPE determineUpdateType() {
        if (this.getKeyStore() != null && this.getJWT() != null) {
            return UPDATE_TYPE.X509_JWT;
        }
        if (this.getKeyStore() != null) {
            return UPDATE_TYPE.X509;
        }
        if (this.getJWT() != null) {
            return UPDATE_TYPE.JWT;
        }
        return UPDATE_TYPE.UNDEFINED;
    }

    public static enum UPDATE_TYPE {
        X509,
        JWT,
        X509_JWT,
        UNDEFINED;

    }
}

