/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class GetEphemeralsTest
extends ClientBase {
    private static final String BASE = "/base";
    private static final int PERSISTENT_CNT = 2;
    private static final int EPHEMERAL_CNT = 2;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String[] expected;
    private ZooKeeper zk;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.expected = this.generatePaths(2, 2);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testGetEphemeralsSync() throws KeeperException, InterruptedException {
        List<String> actual = this.zk.getEphemerals();
        Assert.assertEquals((String)"Expected ephemeral count for allPaths", (long)actual.size(), (long)this.expected.length);
        for (int i = 0; i < this.expected.length; ++i) {
            String path = this.expected[i];
            Assert.assertTrue((String)String.format("Path=%s exists in get All Ephemerals list ", path), (boolean)actual.contains(path));
        }
    }

    @Test
    public void testGetEphemeralsSyncByPath() throws KeeperException, InterruptedException {
        String prefixPath = "/base0";
        List<String> actual = this.zk.getEphemerals("/base0");
        Assert.assertEquals((String)"Expected ephemeral count for allPaths", (long)actual.size(), (long)2L);
        for (int i = 0; i < 2; ++i) {
            String path = this.expected[i];
            Assert.assertTrue((String)String.format("Path=%s exists in getEphemerals(%s) list ", path, "/base0"), (boolean)actual.contains(path));
        }
    }

    @Test
    public void testGetEphemerals() throws IOException, KeeperException, InterruptedException {
        final CountDownLatch doneProcessing = new CountDownLatch(1);
        final ArrayList<String> unexpectedBehavior = new ArrayList<String>();
        this.zk.getEphemerals(new AsyncCallback.EphemeralsCallback(){

            @Override
            public void processResult(int rc, Object ctx, List<String> paths) {
                if (paths == null) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for allPaths to be %d but was null", GetEphemeralsTest.this.expected.length));
                } else if (paths.size() != GetEphemeralsTest.this.expected.length) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for allPaths to be %d but was %d", GetEphemeralsTest.this.expected.length, paths.size()));
                }
                for (int i = 0; i < GetEphemeralsTest.this.expected.length; ++i) {
                    String path = GetEphemeralsTest.this.expected[i];
                    if (paths.contains(path)) continue;
                    unexpectedBehavior.add(String.format("Path=%s exists in getEphemerals list ", path));
                }
                doneProcessing.countDown();
            }
        }, null);
        long waitForCallbackSecs = 2L;
        if (!doneProcessing.await(waitForCallbackSecs, TimeUnit.SECONDS)) {
            Assert.fail((String)String.format("getEphemerals didn't callback within %d seconds", waitForCallbackSecs));
        }
        this.checkForUnexpectedBehavior(unexpectedBehavior);
    }

    @Test
    public void testGetEphemeralsByPath() throws IOException, KeeperException, InterruptedException {
        final CountDownLatch doneProcessing = new CountDownLatch(1);
        String checkPath = "/base0";
        final ArrayList<String> unexpectedBehavior = new ArrayList<String>();
        this.zk.getEphemerals("/base0", new AsyncCallback.EphemeralsCallback(){

            @Override
            public void processResult(int rc, Object ctx, List<String> paths) {
                if (paths == null) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for %s to be %d but was null", "/base0", GetEphemeralsTest.this.expected.length));
                } else if (paths.size() != 2) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for %s to be %d but was %d", "/base0", 2, paths.size()));
                }
                for (int i = 0; i < 2; ++i) {
                    String path = GetEphemeralsTest.this.expected[i];
                    if (paths.contains(path)) continue;
                    unexpectedBehavior.add(String.format("Expected path=%s didn't exist in getEphemerals list.", path));
                }
                doneProcessing.countDown();
            }
        }, null);
        long waitForCallbackSecs = 2L;
        if (!doneProcessing.await(waitForCallbackSecs, TimeUnit.SECONDS)) {
            Assert.fail((String)String.format("getEphemerals(%s) didn't callback within %d seconds", "/base0", waitForCallbackSecs));
        }
        this.checkForUnexpectedBehavior(unexpectedBehavior);
    }

    @Test
    public void testGetEphemeralsEmpty() throws IOException, KeeperException, InterruptedException {
        final CountDownLatch doneProcessing = new CountDownLatch(1);
        String checkPath = "/unknownPath";
        boolean expectedSize = false;
        final ArrayList<String> unexpectedBehavior = new ArrayList<String>();
        this.zk.getEphemerals("/unknownPath", new AsyncCallback.EphemeralsCallback(){

            @Override
            public void processResult(int rc, Object ctx, List<String> paths) {
                if (paths == null) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for %s to be %d but was null", "/unknownPath", 0));
                } else if (paths.size() != 0) {
                    unexpectedBehavior.add(String.format("Expected ephemeral count for %s to be %d but was %d", "/unknownPath", 0, paths.size()));
                }
                doneProcessing.countDown();
            }
        }, null);
        long waitForCallbackSecs = 2L;
        if (!doneProcessing.await(waitForCallbackSecs, TimeUnit.SECONDS)) {
            Assert.fail((String)String.format("getEphemerals(%s) didn't callback within %d seconds", "/unknownPath", waitForCallbackSecs));
        }
        this.checkForUnexpectedBehavior(unexpectedBehavior);
    }

    @Test
    public void testGetEphemeralsErrors() throws KeeperException {
        try {
            this.zk.getEphemerals(null, null, null);
            Assert.fail((String)"Should have thrown a IllegalArgumentException for a null prefixPath");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.zk.getEphemerals("no leading slash", null, null);
            Assert.fail((String)"Should have thrown a IllegalArgumentException for a prefix with no leading slash");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String[] generatePaths(int persistantCnt, int ephemeralCnt) throws KeeperException, InterruptedException {
        String[] expected = new String[persistantCnt * ephemeralCnt];
        for (int p = 0; p < persistantCnt; ++p) {
            String base = BASE + p;
            this.zk.create(base, base.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int e = 0; e < ephemeralCnt; ++e) {
                String ephem = base + "/ephem" + e;
                this.zk.create(ephem, ephem.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                expected[p * ephemeralCnt + e] = ephem;
            }
        }
        return expected;
    }

    private void checkForUnexpectedBehavior(List<String> unexpectedBehavior) {
        if (unexpectedBehavior.size() > 0) {
            StringBuilder b = new StringBuilder("The test failed for the following reasons:");
            b.append(NEWLINE);
            for (String error : unexpectedBehavior) {
                b.append("ERROR: ").append(error).append(NEWLINE);
            }
            Assert.fail((String)b.toString());
        }
    }
}

