/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import io.hops.hadoop.shaded.org.apache.commons.daemon.Daemon;
import io.hops.hadoop.shaded.org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.DNSOperationsFactory;
import org.apache.hadoop.registry.server.dns.RegistryDNS;
import org.apache.hadoop.registry.server.dns.RegistryDNSServer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegedRegistryDNSStarter
implements Daemon {
    private static final Logger LOG = LoggerFactory.getLogger(PrivilegedRegistryDNSStarter.class);
    private YarnConfiguration conf;
    private RegistryDNS registryDNS;
    private RegistryDNSServer registryDNSServer;

    @Override
    public void init(DaemonContext context) throws Exception {
        String[] args = context.getArguments();
        StringUtils.startupShutdownMessage(RegistryDNSServer.class, (String[])args, (Logger)LOG);
        this.conf = new YarnConfiguration();
        new GenericOptionsParser((Configuration)this.conf, args);
        int port = this.conf.getInt("hadoop.registry.dns.bind-port", 5335);
        if (port < 1 || port > 1023) {
            throw new RuntimeException("Must start privileged registry DNS server with 'hadoop.registry.dns.bind-port' configured to a privileged port.");
        }
        try {
            this.registryDNS = (RegistryDNS)DNSOperationsFactory.createInstance((Configuration)this.conf);
            this.registryDNS.initializeChannels((Configuration)this.conf);
        }
        catch (Exception e) {
            LOG.error("Error initializing Registry DNS", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void start() throws Exception {
        this.registryDNSServer = RegistryDNSServer.launchDNSServer((Configuration)this.conf, this.registryDNS);
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void destroy() {
        this.registryDNSServer.stop();
    }
}

