/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.MultiOperationRecord;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.CreateRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.ReconfigRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.RequestHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.SetDataRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SessionTracker;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderBeanTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.ErrorTxn;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessorTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessorTest.class);
    private static final int CONNECTION_TIMEOUT = 3000;
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private CountDownLatch pLatch;
    private ZooKeeperServer zks;
    private ServerCnxnFactory servcnxnf;
    private PrepRequestProcessor processor;
    private Request outcome;
    private boolean isReconfigEnabledPreviously;
    private boolean isStandaloneEnabledPreviously;

    @Before
    public void setup() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        this.zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.servcnxnf = ServerCnxnFactory.createFactory(PORT, -1);
        this.servcnxnf.startup(this.zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        this.zks.sessionTracker = new MySessionTracker();
        this.isReconfigEnabledPreviously = QuorumPeerConfig.isReconfigEnabled();
        this.isStandaloneEnabledPreviously = QuorumPeerConfig.isStandaloneEnabled();
    }

    @After
    public void teardown() throws Exception {
        if (this.servcnxnf != null) {
            this.servcnxnf.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
        QuorumPeerConfig.setReconfigEnabled(this.isReconfigEnabledPreviously);
        QuorumPeerConfig.setStandaloneEnabled(this.isStandaloneEnabledPreviously);
    }

    @Test
    public void testPRequest() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, new MyRequestProcessor());
        Request foo = new Request(null, 1L, 1, 1, ByteBuffer.allocate(3), null);
        this.processor.pRequest(foo);
        Assert.assertEquals((String)"Request should have marshalling error", (Object)new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()), (Object)this.outcome.getTxn());
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    private Request createRequest(Record record, int opCode) throws IOException {
        return this.createRequest(record, opCode, 1L);
    }

    private Request createRequest(Record record, int opCode, long sessionId) throws IOException {
        return this.createRequest(record, opCode, sessionId, false);
    }

    private Request createRequest(Record record, int opCode, boolean admin) throws IOException {
        return this.createRequest(record, opCode, 1L, admin);
    }

    private Request createRequest(Record record, int opCode, long sessionId, boolean admin) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        record.serialize(boa, "request");
        baos.close();
        List<Id> ids = Arrays.asList(admin ? new Id("super", "super user") : ZooDefs.Ids.ANYONE_ID_UNSAFE);
        return new Request(null, sessionId, 0, opCode, ByteBuffer.wrap(baos.toByteArray()), ids);
    }

    private void process(List<Op> ops) throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, new MyRequestProcessor());
        MultiOperationRecord record = new MultiOperationRecord(ops);
        Request req = this.createRequest((Record)record, 14, false);
        this.processor.pRequest(req);
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testMultiOutstandingChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull((Object)this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData("/foo", new byte[0], -1)));
        ZooKeeperServer.ChangeRecord cr = this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertNotNull((String)"Change record wasn't set", (Object)cr);
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)1L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete("/foo", -1)));
        cr = this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete("/foo", -1)));
        cr = this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
    }

    @Test
    public void testReconfigWithAnotherOutstandingChange() throws Exception {
        QuorumPeerConfig.setReconfigEnabled(true);
        QuorumPeerConfig.setStandaloneEnabled(false);
        QuorumPeer qp = new QuorumPeer();
        QuorumVerifier quorumVerifierMock = Mockito.mock(QuorumVerifier.class);
        Mockito.when(quorumVerifierMock.getAllMembers()).thenReturn(LeaderBeanTest.getMockedPeerViews(qp.getId()));
        qp.setQuorumVerifier(quorumVerifierMock, false);
        FileTxnSnapLog snapLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        LeaderZooKeeperServer lzks = new LeaderZooKeeperServer(snapLog, qp, new ZKDatabase(snapLog));
        qp.leader = new Leader(qp, lzks);
        lzks.sessionTracker = new MySessionTracker();
        ZooKeeperServer.setDigestEnabled(true);
        this.processor = new PrepRequestProcessor(lzks, new MyRequestProcessor());
        Record record = new CreateRequest("/foo", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT.toFlag());
        this.pLatch = new CountDownLatch(1);
        this.processor.pRequest(this.createRequest(record, 1, false));
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
        String newMember = "server.0=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant";
        record = new ReconfigRequest(null, null, newMember, 0L);
        this.pLatch = new CountDownLatch(1);
        this.processor.pRequest(this.createRequest(record, 16, true));
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)this.outcome.getHdr().getType(), (long)16L);
    }

    @Test
    public void testMultiRollbackNoLastChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        this.zks.getZKDatabase().dataTree.createNode("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull((Object)this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData("/foo", new byte[0], -1), Op.delete("/foo", -1)));
        Assert.assertNull((Object)this.zks.outstandingChangesForPath.get("/foo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseSessionTxn() throws Exception {
        boolean before = ZooKeeperServer.isCloseSessionTxnEnabled();
        ZooKeeperServer.setCloseSessionTxnEnabled(true);
        try {
            long ephemeralOwner = 1L;
            DataTree dt = this.zks.getZKDatabase().dataTree;
            dt.createNode("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, ephemeralOwner, 0, 0L, 0L);
            dt.createNode("/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, ephemeralOwner, 0, 0L, 0L);
            RequestHeader header = new RequestHeader();
            header.setType(-11);
            final FinalRequestProcessor frq = new FinalRequestProcessor(this.zks);
            final CountDownLatch latch = new CountDownLatch(1);
            this.processor = new PrepRequestProcessor(this.zks, new RequestProcessor(){

                @Override
                public void processRequest(Request request) {
                    frq.processRequest(request);
                    latch.countDown();
                }

                @Override
                public void shutdown() {
                }
            });
            this.processor.pRequest(this.createRequest((Record)header, -11, ephemeralOwner));
            Assert.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
            Assert.assertEquals(null, (Object)dt.getNode("/foo"));
            Assert.assertEquals(null, (Object)dt.getNode("/bar"));
        }
        finally {
            ZooKeeperServer.setCloseSessionTxnEnabled(before);
        }
    }

    @Test
    public void testInvalidPath() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, new MyRequestProcessor());
        SetDataRequest record = new SetDataRequest("", new byte[0], -1);
        Request req = this.createRequest((Record)record, 5, false);
        this.processor.pRequest(req);
        this.pLatch.await();
        Assert.assertEquals((long)this.outcome.getHdr().getType(), (long)-1L);
        Assert.assertEquals((Object)this.outcome.getException().code(), (Object)KeeperException.Code.BADARGUMENTS);
    }

    private class MySessionTracker
    implements SessionTracker {
        private MySessionTracker() {
        }

        @Override
        public boolean trackSession(long id, int to) {
            return false;
        }

        @Override
        public boolean commitSession(long id, int to) {
            return false;
        }

        @Override
        public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        @Override
        public long createSession(int sessionTimeout) {
            return 0L;
        }

        @Override
        public void dumpSessions(PrintWriter pwriter) {
        }

        @Override
        public void removeSession(long sessionId) {
        }

        public int upgradeSession(long sessionId) {
            return 0;
        }

        @Override
        public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public boolean touchSession(long sessionId, int sessionTimeout) {
            return false;
        }

        @Override
        public void setSessionClosing(long sessionId) {
        }

        @Override
        public boolean isTrackingSession(long sessionId) {
            return false;
        }

        @Override
        public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        @Override
        public Map<Long, Set<Long>> getSessionExpiryMap() {
            return new HashMap<Long, Set<Long>>();
        }

        @Override
        public long getLocalSessionCount() {
            return 0L;
        }

        @Override
        public boolean isLocalSessionsEnabled() {
            return false;
        }
    }

    private class MyRequestProcessor
    implements RequestProcessor {
        private MyRequestProcessor() {
        }

        @Override
        public void processRequest(Request request) {
            PrepRequestProcessorTest.this.outcome = request;
            PrepRequestProcessorTest.this.pLatch.countDown();
        }

        @Override
        public void shutdown() {
        }
    }
}

