/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server;

import io.hops.hadoop.shaded.org.eclipse.jetty.util.Attributes;
import java.util.HashSet;
import java.util.Set;

class AsyncAttributes
extends Attributes.Wrapper {
    public static final String __ASYNC_PREFIX = "io.hops.hadoop.shaded.javax.servlet.async.";
    private String _requestURI;
    private String _contextPath;
    private String _servletPath;
    private String _pathInfo;
    private String _queryString;

    public AsyncAttributes(Attributes attributes, String requestUri, String contextPath, String servletPath, String pathInfo, String queryString) {
        super(attributes);
        this._requestURI = requestUri;
        this._contextPath = contextPath;
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._queryString = queryString;
    }

    public Object getAttribute(String key) {
        switch (key) {
            case "io.hops.hadoop.shaded.javax.servlet.async.request_uri": {
                return this._requestURI;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.context_path": {
                return this._contextPath;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.servlet_path": {
                return this._servletPath;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.path_info": {
                return this._pathInfo;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.query_string": {
                return this._queryString;
            }
        }
        return super.getAttribute(key);
    }

    public Set<String> getAttributeNameSet() {
        HashSet<String> set = new HashSet<String>();
        super.getAttributeNameSet().stream().filter(name -> !name.startsWith(__ASYNC_PREFIX)).forEach(set::add);
        if (this._requestURI != null) {
            set.add("io.hops.hadoop.shaded.javax.servlet.async.request_uri");
        }
        if (this._contextPath != null) {
            set.add("io.hops.hadoop.shaded.javax.servlet.async.context_path");
        }
        if (this._servletPath != null) {
            set.add("io.hops.hadoop.shaded.javax.servlet.async.servlet_path");
        }
        if (this._pathInfo != null) {
            set.add("io.hops.hadoop.shaded.javax.servlet.async.path_info");
        }
        if (this._queryString != null) {
            set.add("io.hops.hadoop.shaded.javax.servlet.async.query_string");
        }
        return set;
    }

    public void setAttribute(String key, Object value) {
        switch (key) {
            case "io.hops.hadoop.shaded.javax.servlet.async.request_uri": {
                this._requestURI = (String)value;
                break;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.context_path": {
                this._contextPath = (String)value;
                break;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.servlet_path": {
                this._servletPath = (String)value;
                break;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.path_info": {
                this._pathInfo = (String)value;
                break;
            }
            case "io.hops.hadoop.shaded.javax.servlet.async.query_string": {
                this._queryString = (String)value;
                break;
            }
            default: {
                super.setAttribute(key, value);
            }
        }
    }

    public void clearAttributes() {
        this._requestURI = null;
        this._contextPath = null;
        this._servletPath = null;
        this._pathInfo = null;
        this._queryString = null;
        super.clearAttributes();
    }

    public static void applyAsyncAttributes(Attributes attributes, String requestURI, String contextPath, String servletPath, String pathInfo, String queryString) {
        if (requestURI != null) {
            attributes.setAttribute("io.hops.hadoop.shaded.javax.servlet.async.request_uri", (Object)requestURI);
        }
        if (contextPath != null) {
            attributes.setAttribute("io.hops.hadoop.shaded.javax.servlet.async.context_path", (Object)contextPath);
        }
        if (servletPath != null) {
            attributes.setAttribute("io.hops.hadoop.shaded.javax.servlet.async.servlet_path", (Object)servletPath);
        }
        if (pathInfo != null) {
            attributes.setAttribute("io.hops.hadoop.shaded.javax.servlet.async.path_info", (Object)pathInfo);
        }
        if (queryString != null) {
            attributes.setAttribute("io.hops.hadoop.shaded.javax.servlet.async.query_string", (Object)queryString);
        }
    }
}

