/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.handler;

import io.hops.transaction.TransactionInfo;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.handler.TransactionalRequestHandler;
import io.hops.transaction.lock.HdfsTransactionalLockAcquirer;
import io.hops.transaction.lock.TransactionLockAcquirer;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public abstract class HopsTransactionalRequestHandler
extends TransactionalRequestHandler {
    private final String path;

    public HopsTransactionalRequestHandler(HDFSOperationType opType) {
        this(opType, null);
    }

    public HopsTransactionalRequestHandler(HDFSOperationType opType, String path) {
        super((RequestHandler.OperationType)opType);
        this.path = path;
    }

    protected TransactionLockAcquirer newLockAcquirer() {
        return new HdfsTransactionalLockAcquirer();
    }

    protected Object execute(final Object namesystem) throws IOException {
        return super.execute((Object)new TransactionInfo(){

            public String getContextName(RequestHandler.OperationType opType) {
                if (namesystem != null && namesystem instanceof FSNamesystem) {
                    return "NN (" + ((FSNamesystem)namesystem).getNamenodeId() + ") " + opType.toString() + "[" + Thread.currentThread().getId() + "]";
                }
                return opType.toString();
            }

            public void performPostTransactionAction() throws IOException {
                if (namesystem != null && namesystem instanceof FSNamesystem) {
                    ((FSNamesystem)namesystem).performPendingSafeModeOperation();
                }
            }
        });
    }

    protected final void preTransactionSetup() throws IOException {
        this.setUp();
    }

    public void setUp() throws IOException {
    }

    protected final boolean shouldAbort(Exception e) {
        return !(e instanceof RecoveryInProgressException.NonAbortingRecoveryInProgressException);
    }
}

