/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.jute.OutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LeaderBeanTest {
    private Leader leader;
    private LeaderBean leaderBean;
    private FileTxnSnapLog fileTxnSnapLog;
    private LeaderZooKeeperServer zks;
    private QuorumPeer qp;
    private QuorumVerifier quorumVerifierMock;

    public static Map<Long, QuorumPeer.QuorumServer> getMockedPeerViews(long myId) {
        int clientPort = PortAssignment.unique();
        HashMap<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
        InetAddress clientIP = InetAddress.getLoopbackAddress();
        peersView.put(myId, new QuorumPeer.QuorumServer(myId, new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, clientPort), QuorumPeer.LearnerType.PARTICIPANT));
        return peersView;
    }

    @Before
    public void setUp() throws IOException, X509Exception {
        this.qp = new QuorumPeer();
        this.quorumVerifierMock = Mockito.mock(QuorumVerifier.class);
        Mockito.when(this.quorumVerifierMock.getAllMembers()).thenReturn(LeaderBeanTest.getMockedPeerViews(this.qp.getId()));
        this.qp.setQuorumVerifier(this.quorumVerifierMock, false);
        File tmpDir = ClientBase.createEmptyTestDir();
        this.fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZKDatabase zkDb = new ZKDatabase(this.fileTxnSnapLog);
        this.zks = new LeaderZooKeeperServer(this.fileTxnSnapLog, this.qp, zkDb);
        this.leader = new Leader(this.qp, this.zks);
        this.leaderBean = new LeaderBean(this.leader, this.zks);
    }

    @After
    public void tearDown() throws IOException {
        this.fileTxnSnapLog.close();
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"Leader", (Object)this.leaderBean.getName());
    }

    @Test
    public void testGetCurrentZxid() {
        this.zks.setZxid(1L);
        Assert.assertEquals((Object)"0x1", (Object)this.leaderBean.getCurrentZxid());
    }

    @Test
    public void testGetElectionTimeTaken() {
        this.qp.setElectionTimeTaken(1L);
        Assert.assertEquals((long)1L, (long)this.leaderBean.getElectionTimeTaken());
    }

    @Test
    public void testGetProposalSize() throws IOException, Leader.XidRolloverException {
        Request req = this.createMockRequest();
        this.leader.propose(req);
        byte[] data = SerializeUtils.serializeRequest(req);
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getLastProposalSize());
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getMinProposalSize());
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getMaxProposalSize());
    }

    @Test
    public void testResetProposalStats() throws IOException, Leader.XidRolloverException {
        int initialProposalSize = this.leaderBean.getLastProposalSize();
        Request req = this.createMockRequest();
        this.leader.propose(req);
        Assert.assertNotEquals((long)initialProposalSize, (long)this.leaderBean.getLastProposalSize());
        this.leaderBean.resetProposalStatistics();
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getLastProposalSize());
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getMinProposalSize());
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getMaxProposalSize());
    }

    private Request createMockRequest() throws IOException {
        TxnHeader header = Mockito.mock(TxnHeader.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when(header).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Record txn = Mockito.mock(Record.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("record", "test");
                return null;
            }
        }).when(txn).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        return new Request(1L, 2, 3, header, txn, 4L);
    }

    @Test
    public void testFollowerInfo() throws IOException {
        HashMap<Long, Object> votingMembers = new HashMap<Long, Object>();
        votingMembers.put(1L, null);
        votingMembers.put(2L, null);
        votingMembers.put(3L, null);
        Mockito.when(this.quorumVerifierMock.getVotingMembers()).thenReturn(votingMembers);
        LearnerHandler follower = Mockito.mock(LearnerHandler.class);
        Mockito.when(follower.getLearnerType()).thenReturn(QuorumPeer.LearnerType.PARTICIPANT);
        Mockito.when(follower.toString()).thenReturn("1");
        Mockito.when(follower.getSid()).thenReturn(1L);
        this.leader.addLearnerHandler(follower);
        this.leader.addForwardingFollower(follower);
        Assert.assertEquals((Object)"1\n", (Object)this.leaderBean.followerInfo());
        Assert.assertEquals((Object)"", (Object)this.leaderBean.nonVotingFollowerInfo());
        LearnerHandler observer = Mockito.mock(LearnerHandler.class);
        Mockito.when(observer.getLearnerType()).thenReturn(QuorumPeer.LearnerType.OBSERVER);
        Mockito.when(observer.toString()).thenReturn("2");
        this.leader.addLearnerHandler(observer);
        Assert.assertEquals((Object)"1\n", (Object)this.leaderBean.followerInfo());
        Assert.assertEquals((Object)"", (Object)this.leaderBean.nonVotingFollowerInfo());
        LearnerHandler nonVotingFollower = Mockito.mock(LearnerHandler.class);
        Mockito.when(nonVotingFollower.getLearnerType()).thenReturn(QuorumPeer.LearnerType.PARTICIPANT);
        Mockito.when(nonVotingFollower.toString()).thenReturn("5");
        Mockito.when(nonVotingFollower.getSid()).thenReturn(5L);
        this.leader.addLearnerHandler(nonVotingFollower);
        this.leader.addForwardingFollower(nonVotingFollower);
        String followerInfo = this.leaderBean.followerInfo();
        Assert.assertTrue((boolean)followerInfo.contains("1"));
        Assert.assertTrue((boolean)followerInfo.contains("5"));
        Assert.assertEquals((Object)"5\n", (Object)this.leaderBean.nonVotingFollowerInfo());
    }
}

