/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.servlet;

import io.hops.hadoop.shaded.javax.servlet.Filter;
import io.hops.hadoop.shaded.javax.servlet.FilterChain;
import io.hops.hadoop.shaded.javax.servlet.Servlet;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletRequestEvent;
import io.hops.hadoop.shaded.javax.servlet.ServletRequestListener;
import io.hops.hadoop.shaded.javax.servlet.ServletResponse;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterChainInvoker;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterRegistration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.WebappContext;
import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FilterChainImpl
implements FilterChain,
FilterChainInvoker {
    private static final Logger LOGGER = Grizzly.logger(FilterChainImpl.class);
    private final Servlet servlet;
    private final WebappContext ctx;
    private final Object lock = new Object();
    private int n;
    private FilterRegistration[] filters = new FilterRegistration[0];
    private int pos;

    public FilterChainImpl(Servlet servlet, WebappContext ctx) {
        this.servlet = servlet;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletRequestEvent event = new ServletRequestEvent((ServletContext)this.ctx, request);
        try {
            this.requestInitialized(event);
            this.pos = 0;
            this.doFilter(request, response);
        }
        finally {
            this.requestDestroyed(event);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            FilterRegistration registration = this.filters[this.pos++];
            try {
                Filter filter = registration.filter;
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            return;
        }
        try {
            if (this.servlet != null) {
                this.servlet.service(request, response);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilter(FilterRegistration filterRegistration) {
        Object object = this.lock;
        synchronized (object) {
            if (this.n == this.filters.length) {
                FilterRegistration[] newFilters = new FilterRegistration[this.n + 4];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filterRegistration;
        }
    }

    private void requestDestroyed(ServletRequestEvent event) {
        EventListener[] listeners = this.ctx.getEventListeners();
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestListener)) continue;
            try {
                ((ServletRequestListener)listeners[i]).requestDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR("requestDestroyed", "ServletRequestListener", listeners[i].getClass().getName()), t);
            }
        }
    }

    private void requestInitialized(ServletRequestEvent event) {
        EventListener[] listeners = this.ctx.getEventListeners();
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestListener)) continue;
            try {
                ((ServletRequestListener)listeners[i]).requestInitialized(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR("requestDestroyed", "ServletRequestListener", listeners[i].getClass().getName()), t);
            }
        }
    }
}

