/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.common.BCFKSFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509KeyType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509TestContext;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BCFKSFileLoaderTest
extends BaseX509ParameterizedTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return BaseX509ParameterizedTestCase.defaultParams();
    }

    public BCFKSFileLoaderTest(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) {
        super(paramIndex, () -> {
            try {
                return X509TestContext.newBuilder().setTempDir(tempDir).setKeyStorePassword(keyPassword).setKeyStoreKeyType(certKeyType).setTrustStorePassword(keyPassword).setTrustStoreKeyType(caKeyType).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLoadKeyStore() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        KeyStore ks = ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        Assert.assertEquals((long)1L, (long)ks.size());
    }

    @Test(expected=Exception.class)
    public void testLoadKeyStoreWithWrongPassword() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword("wrong password").build()).loadKeyStore();
    }

    @Test(expected=IOException.class)
    public void testLoadKeyStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setKeyStorePath(path + ".does_not_exist").setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadKeyStoreWithNullFilePath() throws Exception {
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=IOException.class)
    public void testLoadKeyStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test
    public void testLoadTrustStore() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        KeyStore ts = ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        Assert.assertEquals((long)1L, (long)ts.size());
    }

    @Test(expected=Exception.class)
    public void testLoadTrustStoreWithWrongPassword() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setTrustStorePath(path).setTrustStorePassword("wrong password").build()).loadTrustStore();
    }

    @Test(expected=IOException.class)
    public void testLoadTrustStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.BCFKS).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setTrustStorePath(path + ".does_not_exist").setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustStoreWithNullFilePath() throws Exception {
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test(expected=IOException.class)
    public void testLoadTrustStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((BCFKSFileLoader)new BCFKSFileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }
}

