/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class ClientRetryTest
extends ClientBase {
    @Override
    public void setUp() throws Exception {
        this.maxCnxns = 1;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRetry() throws IOException, InterruptedException, TimeoutException {
        ClientBase.CountdownWatcher cdw1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher cdw2 = new ClientBase.CountdownWatcher();
        try (ZooKeeper zk = new ZooKeeper(this.hostPort, 10000, cdw1);){
            cdw1.waitForConnected(CONNECTION_TIMEOUT);
            try (ZooKeeper zk2 = new ZooKeeper(this.hostPort, 10000, cdw2);){
                ZooKeeper.States s1 = zk.getState();
                ZooKeeper.States s2 = zk2.getState();
                Assert.assertSame((Object)((Object)s1), (Object)((Object)ZooKeeper.States.CONNECTED));
                Assert.assertSame((Object)((Object)s2), (Object)((Object)ZooKeeper.States.CONNECTING));
                cdw1.reset();
                zk.close();
                cdw1.waitForDisconnected(CONNECTION_TIMEOUT);
                cdw2.waitForConnected(CONNECTION_TIMEOUT);
                Assert.assertSame((Object)((Object)zk2.getState()), (Object)((Object)ZooKeeper.States.CONNECTED));
            }
        }
    }
}

