/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.cli;

import io.hops.hadoop.shaded.org.apache.commons.cli.CommandLine;
import io.hops.hadoop.shaded.org.apache.commons.cli.Options;
import io.hops.hadoop.shaded.org.apache.commons.cli.ParseException;
import io.hops.hadoop.shaded.org.apache.commons.cli.PosixParser;
import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    public static final long SYNC_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    public SyncCommand() {
        super("sync", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        final CompletableFuture cf = new CompletableFuture();
        try {
            this.zk.sync(path, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    cf.complete(rc);
                }
            }, null);
            int resultCode = (Integer)cf.get(SYNC_TIMEOUT, TimeUnit.MILLISECONDS);
            if (resultCode == 0) {
                this.out.println("Sync is OK");
            } else {
                this.out.println("Sync has failed. rc=" + resultCode);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new CliWrapperException(ie);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

