/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ZKTrustManager;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.ASN1Encodable;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.X500NameBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x509.BasicConstraints;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x509.Extension;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x509.GeneralName;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x509.GeneralNames;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x509.KeyUsage;
import io.hops.hadoop.shaded.org.bouncycastle.cert.X509v3CertificateBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import io.hops.hadoop.shaded.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import io.hops.hadoop.shaded.org.bouncycastle.operator.ContentSigner;
import io.hops.hadoop.shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZKTrustManagerTest
extends ZKTestCase {
    private static KeyPair keyPair;
    private X509ExtendedTrustManager mockX509ExtendedTrustManager;
    private static final String IP_ADDRESS = "127.0.0.1";
    private static final String HOSTNAME = "localhost";
    private InetAddress mockInetAddress;
    private Socket mockSocket;

    @BeforeClass
    public static void createKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096);
        keyPair = keyPairGenerator.genKeyPair();
    }

    @AfterClass
    public static void removeBouncyCastleProvider() throws Exception {
        Security.removeProvider("BC");
    }

    @Before
    public void setup() throws Exception {
        this.mockX509ExtendedTrustManager = Mockito.mock(X509ExtendedTrustManager.class);
        this.mockInetAddress = Mockito.mock(InetAddress.class);
        Mockito.when(this.mockInetAddress.getHostAddress()).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ZKTrustManagerTest.IP_ADDRESS;
            }
        });
        Mockito.when(this.mockInetAddress.getHostName()).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ZKTrustManagerTest.HOSTNAME;
            }
        });
        this.mockSocket = Mockito.mock(Socket.class);
        Mockito.when(this.mockSocket.getInetAddress()).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ZKTrustManagerTest.this.mockInetAddress;
            }
        });
    }

    private X509Certificate[] createSelfSignedCertifcateChain(String ipAddress, String hostname) throws Exception {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, "NOT_LOCALHOST");
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(1, 1);
        Date notAfter = cal.getTime();
        BigInteger serialNumber = new BigInteger(128, new Random());
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic()).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        if (ipAddress != null) {
            generalNames.add(new GeneralName(7, ipAddress));
        }
        if (hostname != null) {
            generalNames.add(new GeneralName(2, hostname));
        }
        if (!generalNames.isEmpty()) {
            certificateBuilder.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[0])));
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner))};
    }

    @Test
    public void testServerHostnameVerificationWithHostnameVerificationDisabled() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithHostnameVerificationDisabledAndClientHostnameVerificationEnabled() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithIPAddress() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, null);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithHostname() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithHostnameVerificationDisabled() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithClientHostnameVerificationDisabled() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithIPAddress() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, null);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(0)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithHostname() throws Exception {
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostAddress();
        Mockito.verify(this.mockInetAddress, Mockito.times(1)).getHostName();
        Mockito.verify(this.mockX509ExtendedTrustManager, Mockito.times(1)).checkClientTrusted(certificateChain, null, this.mockSocket);
    }
}

