/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool;

import io.hops.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeBuilder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeHolder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.ThreadLocalPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.WorkerThread;
import java.util.concurrent.TimeUnit;

public class DefaultWorkerThread
extends Thread
implements WorkerThread {
    private final AttributeHolder attributes;
    private final ThreadLocalPool memoryPool;
    private final ThreadCache.ObjectCache objectCache = new ThreadCache.ObjectCache();
    private long transactionTimeoutMillis = -1L;
    private boolean isSelectorThread;

    public DefaultWorkerThread(AttributeBuilder attrBuilder, String name, ThreadLocalPool pool, Runnable runTask) {
        super(runTask, name);
        this.attributes = new IndexedAttributeHolder(attrBuilder);
        this.memoryPool = pool;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public ThreadLocalPool getMemoryPool() {
        return this.memoryPool;
    }

    public final <E> E getFromCache(ThreadCache.CachedTypeIndex<E> index) {
        return this.objectCache.get(index);
    }

    public final <E> E takeFromCache(ThreadCache.CachedTypeIndex<E> index) {
        return this.objectCache.take(index);
    }

    public final <E> boolean putToCache(ThreadCache.CachedTypeIndex<E> index, E o) {
        return this.objectCache.put(index, o);
    }

    @Override
    public long getTransactionTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTransactionTimeout(long timeout, TimeUnit timeunit) {
        this.transactionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }

    @Override
    public boolean isSelectorThread() {
        return this.isSelectorThread;
    }

    @Override
    public void setSelectorThread(boolean isSelectorThread) {
        this.isSelectorThread = isSelectorThread;
    }
}

