/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.context;

import io.hops.hadoop.shaded.org.terracotta.context.ContextElement;
import io.hops.hadoop.shaded.org.terracotta.context.TreeNode;
import io.hops.hadoop.shaded.org.terracotta.statistics.StatisticsManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class ContextAwareTreeNode
implements TreeNode {
    private Object context;
    private TreeNode wrappedNode;

    public ContextAwareTreeNode(TreeNode node, Object context) {
        this.context = context;
        this.wrappedNode = node;
    }

    @Override
    public Set<? extends TreeNode> getChildren() {
        return this.wrappedNode.getChildren();
    }

    @Override
    public List<? extends TreeNode> getPath() throws IllegalStateException {
        return this.wrappedNode.getPath();
    }

    @Override
    public Collection<List<? extends TreeNode>> getPaths() {
        return this.wrappedNode.getPaths();
    }

    @Override
    public ContextElement getContext() {
        return this.wrappedNode.getContext();
    }

    @Override
    public String toTreeString() {
        return this.wrappedNode.toTreeString();
    }

    @Override
    public void clean() {
        this.wrappedNode.clean();
        StatisticsManager.removePassThroughStatistics(this.context);
    }
}

