/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OOMTest
extends ZKTestCase {
    private static final Watcher TEST_WATCHER = event -> System.err.println("Got event: " + event);

    @Test
    @Ignore
    public void testOOM() throws IOException, InterruptedException, KeeperException {
        File tmpDir = ClientBase.createTmpDir();
        ArrayList<byte[]> hog = new ArrayList<byte[]>();
        try {
            while (true) {
                hog.add(new byte[0x200000]);
            }
        }
        catch (OutOfMemoryError e) {
            int i;
            hog.remove(0);
            ClientBase.setupTestEnv();
            ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
            int PORT = PortAssignment.unique();
            ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
            f.startup(zks);
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + PORT, ClientBase.CONNECTION_TIMEOUT));
            System.err.println("OOM Stage 0");
            this.utestPrep(PORT);
            System.out.println("Free = " + Runtime.getRuntime().freeMemory() + " total = " + Runtime.getRuntime().totalMemory() + " max = " + Runtime.getRuntime().maxMemory());
            System.err.println("OOM Stage 1");
            for (i = 0; i < 1000; ++i) {
                System.out.println(i);
                this.utestExists(PORT);
            }
            System.out.println("Free = " + Runtime.getRuntime().freeMemory() + " total = " + Runtime.getRuntime().totalMemory() + " max = " + Runtime.getRuntime().maxMemory());
            System.err.println("OOM Stage 2");
            for (i = 0; i < 1000; ++i) {
                System.out.println(i);
                this.utestGet(PORT);
            }
            System.out.println("Free = " + Runtime.getRuntime().freeMemory() + " total = " + Runtime.getRuntime().totalMemory() + " max = " + Runtime.getRuntime().maxMemory());
            System.err.println("OOM Stage 3");
            for (i = 0; i < 1000; ++i) {
                System.out.println(i);
                this.utestChildren(PORT);
            }
            System.out.println("Free = " + Runtime.getRuntime().freeMemory() + " total = " + Runtime.getRuntime().totalMemory() + " max = " + Runtime.getRuntime().maxMemory());
            ((byte[])hog.get((int)0))[0] = 1;
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, ClientBase.CONNECTION_TIMEOUT));
            return;
        }
    }

    private void utestExists(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, TEST_WATCHER);
        for (int i = 0; i < 10000; ++i) {
            zk.exists("/this/path/doesnt_exist!", true);
        }
        zk.close();
    }

    private void utestPrep(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, TEST_WATCHER);
        for (int i = 0; i < 10000; ++i) {
            zk.create("/" + i, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    private void utestGet(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, TEST_WATCHER);
        for (int i = 0; i < 10000; ++i) {
            Stat stat = new Stat();
            zk.getData("/" + i, true, stat);
        }
        zk.close();
    }

    private void utestChildren(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, TEST_WATCHER);
        for (int i = 0; i < 10000; ++i) {
            zk.getChildren("/" + i, true);
        }
        zk.close();
    }
}

