/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AddWatchMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchesPathReport;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchesSummary;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UnsupportedAddWatcherTest
extends ClientBase {
    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("zookeeper.watchManagerName", StubbedWatchManager.class.getName());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            System.clearProperty("zookeeper.watchManagerName");
        }
    }

    @Test(expected=KeeperException.MarshallingErrorException.class)
    public void testBehavior() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(this.hostPort);){
            zk.addWatch("/foo", event -> {}, AddWatchMode.PERSISTENT_RECURSIVE);
        }
    }

    public static class StubbedWatchManager
    implements IWatchManager {
        @Override
        public boolean addWatch(String path, Watcher watcher) {
            return false;
        }

        @Override
        public boolean containsWatcher(String path, Watcher watcher) {
            return false;
        }

        @Override
        public boolean removeWatcher(String path, Watcher watcher) {
            return false;
        }

        @Override
        public void removeWatcher(Watcher watcher) {
        }

        @Override
        public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type) {
            return new WatcherOrBitSet(Collections.emptySet());
        }

        @Override
        public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, WatcherOrBitSet suppress) {
            return new WatcherOrBitSet(Collections.emptySet());
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public WatchesSummary getWatchesSummary() {
            return null;
        }

        @Override
        public WatchesReport getWatches() {
            return null;
        }

        @Override
        public WatchesPathReport getWatchesByPath() {
            return null;
        }

        @Override
        public void dumpWatches(PrintWriter pwriter, boolean byPath) {
        }
    }
}

