/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import io.hops.common.IDsGeneratorFactory;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class IDsMonitor
implements Runnable {
    private static final Log LOG = LogFactory.getLog(IDsMonitor.class);
    private static IDsMonitor instance = null;
    private Thread th = null;
    private boolean isRunning = true;
    private int checkInterval;

    private IDsMonitor() {
    }

    public static IDsMonitor getInstance() {
        if (instance == null) {
            instance = new IDsMonitor();
        }
        return instance;
    }

    public static void reset() {
        IDsGeneratorFactory.reset();
        if (instance != null) {
            instance.stop();
        }
        instance = null;
    }

    public void setConfiguration(Configuration conf) {
        IDsGeneratorFactory.getInstance().setConfiguration(conf.getInt("dfs.namenode.inodeid.batchsize", 1000), conf.getInt("dfs.namenode.blockid.batchsize", 1000), conf.getInt("dfs.namenode.quota.update.id.batchsize", 100000), conf.getInt("dfs.namenode.cache.directive.id.batchsize", 100000), conf.getFloat("dfs.namenode.inodeid.updateThreshold", 0.5f), conf.getFloat("dfs.namenode.blockid.updateThreshold", 0.5f), conf.getFloat("dfs.namenode.quota.update.updateThreshold", 0.5f), conf.getFloat("dfs.namenode.cache.directive.updateThreshold", 0.5f));
        this.checkInterval = conf.getInt("dfs.namenode.id.updateThreshold", 1000);
    }

    public void start() {
        this.isRunning = true;
        this.getNewIds();
        this.th = new Thread((Runnable)this, "IDsMonitor");
        this.th.setDaemon(true);
        this.th.start();
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.getNewIds();
        }
    }

    private void getNewIds() {
        try {
            IDsGeneratorFactory.getInstance().getNewIDs();
            Thread.sleep(this.checkInterval);
        }
        catch (InterruptedException ex) {
            LOG.warn((Object)("IDsMonitor interrupted: " + ex));
        }
        catch (IOException ex) {
            LOG.warn((Object)("IDsMonitor got exception: " + ex));
        }
    }
}

