/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ClientX509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509KeyType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509TestContext;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ZKConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class X509UtilTest
extends BaseX509ParameterizedTestCase {
    private X509Util x509Util;
    private static final String[] customCipherSuites = new String[]{"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return BaseX509ParameterizedTestCase.defaultParams();
    }

    public X509UtilTest(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) {
        super(paramIndex, () -> {
            try {
                return X509TestContext.newBuilder().setTempDir(tempDir).setKeyStorePassword(keyPassword).setKeyStoreKeyType(certKeyType).setTrustStorePassword(keyPassword).setTrustStoreKeyType(caKeyType).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        try (ClientX509Util x509util = new ClientX509Util();){
            this.x509TestContext.setSystemProperties(x509util, KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        }
        System.setProperty("zookeeper.serverCnxnFactory", "io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNetty");
        this.x509Util = new ClientX509Util();
    }

    @After
    public void cleanUp() {
        this.x509TestContext.clearSystemProperties(this.x509Util);
        System.clearProperty(this.x509Util.getSslOcspEnabledProperty());
        System.clearProperty(this.x509Util.getSslCrlEnabledProperty());
        System.clearProperty(this.x509Util.getCipherSuitesProperty());
        System.clearProperty(this.x509Util.getSslProtocolProperty());
        System.clearProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty());
        System.clearProperty("io.hops.hadoop.shaded.com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        this.x509Util.close();
    }

    @Test(timeout=5000L)
    public void testCreateSSLContextWithoutCustomProtocol() throws Exception {
        SSLContext sslContext = this.x509Util.getDefaultSSLContext();
        Assert.assertEquals((Object)"TLSv1.2", (Object)sslContext.getProtocol());
    }

    @Test(timeout=5000L)
    public void testCreateSSLContextWithCustomProtocol() throws Exception {
        String protocol = "TLSv1.1";
        System.setProperty(this.x509Util.getSslProtocolProperty(), "TLSv1.1");
        SSLContext sslContext = this.x509Util.getDefaultSSLContext();
        Assert.assertEquals((Object)"TLSv1.1", (Object)sslContext.getProtocol());
    }

    @Test(timeout=5000L)
    public void testCreateSSLContextWithoutKeyStoreLocation() throws Exception {
        System.clearProperty(this.x509Util.getSslKeystoreLocationProperty());
        this.x509Util.getDefaultSSLContext();
    }

    @Test(timeout=5000L, expected=X509Exception.SSLContextException.class)
    public void testCreateSSLContextWithoutKeyStorePassword() throws Exception {
        if (!this.x509TestContext.isKeyStoreEncrypted()) {
            throw new X509Exception.SSLContextException("");
        }
        System.clearProperty(this.x509Util.getSslKeystorePasswdProperty());
        this.x509Util.getDefaultSSLContext();
    }

    @Test(timeout=5000L)
    public void testCreateSSLContextWithCustomCipherSuites() throws Exception {
        this.setCustomCipherSuites();
        SSLSocket sslSocket = this.x509Util.createSSLSocket();
        Assert.assertArrayEquals((Object[])customCipherSuites, (Object[])sslSocket.getEnabledCipherSuites());
    }

    @Test(timeout=5000L)
    public void testCRLEnabled() throws Exception {
        System.setProperty(this.x509Util.getSslCrlEnabledProperty(), "true");
        this.x509Util.getDefaultSSLContext();
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("io.hops.hadoop.shaded.com.sun.net.ssl.checkRevocation")));
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assert.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @Test(timeout=5000L)
    public void testCRLDisabled() throws Exception {
        this.x509Util.getDefaultSSLContext();
        Assert.assertFalse((boolean)Boolean.valueOf(System.getProperty("io.hops.hadoop.shaded.com.sun.net.ssl.checkRevocation")));
        Assert.assertFalse((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assert.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @Test(timeout=5000L)
    public void testOCSPEnabled() throws Exception {
        System.setProperty(this.x509Util.getSslOcspEnabledProperty(), "true");
        this.x509Util.getDefaultSSLContext();
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("io.hops.hadoop.shaded.com.sun.net.ssl.checkRevocation")));
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assert.assertTrue((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @Test(timeout=5000L)
    public void testCreateSSLSocket() throws Exception {
        this.setCustomCipherSuites();
        SSLSocket sslSocket = this.x509Util.createSSLSocket();
        Assert.assertArrayEquals((Object[])customCipherSuites, (Object[])sslSocket.getEnabledCipherSuites());
    }

    @Test(timeout=5000L)
    public void testCreateSSLServerSocketWithoutPort() throws Exception {
        this.setCustomCipherSuites();
        SSLServerSocket sslServerSocket = this.x509Util.createSSLServerSocket();
        Assert.assertArrayEquals((Object[])customCipherSuites, (Object[])sslServerSocket.getEnabledCipherSuites());
        Assert.assertTrue((boolean)sslServerSocket.getNeedClientAuth());
    }

    @Test(timeout=5000L)
    public void testCreateSSLServerSocketWithPort() throws Exception {
        this.setCustomCipherSuites();
        int port = PortAssignment.unique();
        SSLServerSocket sslServerSocket = this.x509Util.createSSLServerSocket(port);
        Assert.assertEquals((long)sslServerSocket.getLocalPort(), (long)port);
        Assert.assertArrayEquals((Object[])customCipherSuites, (Object[])sslServerSocket.getEnabledCipherSuites());
        Assert.assertTrue((boolean)sslServerSocket.getNeedClientAuth());
    }

    @Test
    public void testLoadPEMKeyStore() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMKeyStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMKeyStoreAutodetectStoreFileType() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test(expected=X509Exception.KeyManagerException.class)
    public void testLoadPEMKeyStoreWithWrongPassword() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), "wrong password", KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMTrustStore() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), KeyStoreFileType.PEM.getPropertyValue(), false, false, true, true);
    }

    @Test
    public void testLoadPEMTrustStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, KeyStoreFileType.PEM.getPropertyValue(), false, false, true, true);
    }

    @Test
    public void testLoadPEMTrustStoreAutodetectStoreFileType() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), null, false, false, true, true);
    }

    @Test
    public void testLoadJKSKeyStore() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), KeyStoreFileType.JKS.getPropertyValue());
    }

    @Test
    public void testLoadJKSKeyStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, KeyStoreFileType.JKS.getPropertyValue());
    }

    @Test
    public void testLoadJKSKeyStoreAutodetectStoreFileType() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test(expected=X509Exception.KeyManagerException.class)
    public void testLoadJKSKeyStoreWithWrongPassword() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), "wrong password", KeyStoreFileType.JKS.getPropertyValue());
    }

    @Test
    public void testLoadJKSTrustStore() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), KeyStoreFileType.JKS.getPropertyValue(), true, true, true, true);
    }

    @Test
    public void testLoadJKSTrustStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, KeyStoreFileType.JKS.getPropertyValue(), false, false, true, true);
    }

    @Test
    public void testLoadJKSTrustStoreAutodetectStoreFileType() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), null, true, true, true, true);
    }

    @Test(expected=X509Exception.TrustManagerException.class)
    public void testLoadJKSTrustStoreWithWrongPassword() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), "wrong password", KeyStoreFileType.JKS.getPropertyValue(), true, true, true, true);
    }

    @Test
    public void testLoadPKCS12KeyStore() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @Test
    public void testLoadPKCS12KeyStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @Test
    public void testLoadPKCS12KeyStoreAutodetectStoreFileType() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test(expected=X509Exception.KeyManagerException.class)
    public void testLoadPKCS12KeyStoreWithWrongPassword() throws Exception {
        X509KeyManager km = X509Util.createKeyManager(this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), "wrong password", KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @Test
    public void testLoadPKCS12TrustStore() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), KeyStoreFileType.PKCS12.getPropertyValue(), true, true, true, true);
    }

    @Test
    public void testLoadPKCS12TrustStoreNullPassword() throws Exception {
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, KeyStoreFileType.PKCS12.getPropertyValue(), false, false, true, true);
    }

    @Test
    public void testLoadPKCS12TrustStoreAutodetectStoreFileType() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), this.x509TestContext.getTrustStorePassword(), null, true, true, true, true);
    }

    @Test(expected=X509Exception.TrustManagerException.class)
    public void testLoadPKCS12TrustStoreWithWrongPassword() throws Exception {
        X509TrustManager tm = X509Util.createTrustManager(this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), "wrong password", KeyStoreFileType.PKCS12.getPropertyValue(), true, true, true, true);
    }

    @Test
    public void testGetSslHandshakeDetectionTimeoutMillisProperty() {
        Assert.assertEquals((long)5000L, (long)this.x509Util.getSslHandshakeTimeoutMillis());
        String newPropertyString = Integer.toString(5001);
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), newPropertyString);
        try (ClientX509Util tempX509Util = new ClientX509Util();){
            Assert.assertEquals((long)5001L, (long)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "0");
        tempX509Util = new ClientX509Util();
        var3_3 = null;
        try {
            Assert.assertEquals((long)5000L, (long)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tempX509Util != null) {
                if (var3_3 != null) {
                    try {
                        tempX509Util.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tempX509Util.close();
                }
            }
        }
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "-1");
        tempX509Util = new ClientX509Util();
        var3_3 = null;
        try {
            Assert.assertEquals((long)5000L, (long)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tempX509Util != null) {
                if (var3_3 != null) {
                    try {
                        tempX509Util.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tempX509Util.close();
                }
            }
        }
    }

    @Test(expected=X509Exception.SSLContextException.class)
    public void testCreateSSLContext_invalidCustomSSLContextClass() throws Exception {
        ZKConfig zkConfig = new ZKConfig();
        ClientX509Util clientX509Util = new ClientX509Util();
        zkConfig.setProperty(clientX509Util.getSslContextSupplierClassProperty(), String.class.getCanonicalName());
        clientX509Util.createSSLContext(zkConfig);
    }

    @Test
    public void testCreateSSLContext_validCustomSSLContextClass() throws Exception {
        ZKConfig zkConfig = new ZKConfig();
        ClientX509Util clientX509Util = new ClientX509Util();
        zkConfig.setProperty(clientX509Util.getSslContextSupplierClassProperty(), SslContextSupplier.class.getName());
        SSLContext sslContext = clientX509Util.createSSLContext(zkConfig);
        Assert.assertEquals((Object)SSLContext.getDefault(), (Object)sslContext);
    }

    private static void forceClose(Socket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void forceClose(ServerSocket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SSLHandshakeException.class)
    public void testClientRenegotiationFails() throws Throwable {
        int port = PortAssignment.unique();
        ExecutorService workerPool = Executors.newCachedThreadPool();
        final SSLServerSocket listeningSocket = this.x509Util.createSSLServerSocket();
        SSLSocket clientSocket = null;
        SSLSocket serverSocket = null;
        final AtomicInteger handshakesCompleted = new AtomicInteger(0);
        final CountDownLatch handshakeCompleted = new CountDownLatch(1);
        try {
            InetSocketAddress localServerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            listeningSocket.bind(localServerAddress);
            Future<SSLSocket> acceptFuture = workerPool.submit(new Callable<SSLSocket>(){

                @Override
                public SSLSocket call() throws Exception {
                    SSLSocket sslSocket = (SSLSocket)listeningSocket.accept();
                    sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        @Override
                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                            handshakesCompleted.getAndIncrement();
                            handshakeCompleted.countDown();
                        }
                    });
                    Assert.assertEquals((long)1L, (long)sslSocket.getInputStream().read());
                    try {
                        sslSocket.getInputStream().read();
                        return sslSocket;
                    }
                    catch (Exception e) {
                        X509UtilTest.forceClose(sslSocket);
                        throw e;
                    }
                }
            });
            clientSocket = this.x509Util.createSSLSocket();
            clientSocket.connect(localServerAddress);
            clientSocket.getOutputStream().write(1);
            clientSocket.startHandshake();
            clientSocket.getOutputStream().write(1);
            try {
                serverSocket = acceptFuture.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        catch (Throwable throwable) {
            X509UtilTest.forceClose(serverSocket);
            X509UtilTest.forceClose(clientSocket);
            X509UtilTest.forceClose(listeningSocket);
            workerPool.shutdown();
            handshakeCompleted.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)handshakesCompleted.get());
            throw throwable;
        }
        X509UtilTest.forceClose(serverSocket);
        X509UtilTest.forceClose(clientSocket);
        X509UtilTest.forceClose(listeningSocket);
        workerPool.shutdown();
        handshakeCompleted.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)handshakesCompleted.get());
    }

    @Test
    public void testGetDefaultCipherSuitesJava8() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion("1.8");
        Assert.assertTrue((boolean)cipherSuites[0].contains("CBC"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava9() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion("9");
        Assert.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava10() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion("10");
        Assert.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava11() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion("11");
        Assert.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesUnknownVersion() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion("notaversion");
        Assert.assertTrue((boolean)cipherSuites[0].contains("CBC"));
    }

    @Test(expected=NullPointerException.class)
    public void testGetDefaultCipherSuitesNullVersion() {
        X509Util.getDefaultCipherSuitesForJavaVersion(null);
    }

    private void setCustomCipherSuites() {
        System.setProperty(this.x509Util.getCipherSuitesProperty(), customCipherSuites[0] + "," + customCipherSuites[1]);
        this.x509Util.close();
        this.x509Util = new ClientX509Util();
    }

    public static class SslContextSupplier
    implements Supplier<SSLContext> {
        @Override
        public SSLContext get() {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

