/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.command.FourLetterCommands;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.command.StatCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.BufferStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatCommandTest {
    private StringWriter outputWriter;
    private StatCommand statCommand;
    private ServerStats.Provider providerMock;

    @Before
    public void setUp() {
        this.outputWriter = new StringWriter();
        ServerCnxn serverCnxnMock = Mockito.mock(ServerCnxn.class);
        LeaderZooKeeperServer zks = Mockito.mock(LeaderZooKeeperServer.class);
        Mockito.when(zks.isRunning()).thenReturn(true);
        this.providerMock = Mockito.mock(ServerStats.Provider.class);
        Mockito.when(zks.serverStats()).thenReturn(new ServerStats(this.providerMock));
        ZKDatabase zkDatabaseMock = Mockito.mock(ZKDatabase.class);
        Mockito.when(zks.getZKDatabase()).thenReturn(zkDatabaseMock);
        Leader leaderMock = Mockito.mock(Leader.class);
        Mockito.when(leaderMock.getProposalStats()).thenReturn(new BufferStats());
        Mockito.when(zks.getLeader()).thenReturn(leaderMock);
        ServerCnxnFactory serverCnxnFactory = Mockito.mock(ServerCnxnFactory.class);
        ServerCnxn serverCnxn = Mockito.mock(ServerCnxn.class);
        ArrayList<ServerCnxn> connections = new ArrayList<ServerCnxn>();
        connections.add(serverCnxn);
        Mockito.when(serverCnxnFactory.getConnections()).thenReturn(connections);
        this.statCommand = new StatCommand(new PrintWriter(this.outputWriter), serverCnxnMock, FourLetterCommands.statCmd);
        this.statCommand.setZkServer(zks);
        this.statCommand.setFactory(serverCnxnFactory);
    }

    @Test
    public void testLeaderStatCommand() {
        Mockito.when(this.providerMock.getState()).thenReturn("leader");
        this.statCommand.commandRun();
        String output = this.outputWriter.toString();
        this.assertCommonStrings(output);
        Assert.assertThat((Object)output, CoreMatchers.containsString("Mode: leader"));
        Assert.assertThat((Object)output, CoreMatchers.containsString("Proposal sizes last/min/max:"));
    }

    @Test
    public void testFollowerStatCommand() {
        Mockito.when(this.providerMock.getState()).thenReturn("follower");
        this.statCommand.commandRun();
        String output = this.outputWriter.toString();
        this.assertCommonStrings(output);
        Assert.assertThat((Object)output, CoreMatchers.containsString("Mode: follower"));
    }

    private void assertCommonStrings(String output) {
        Assert.assertThat((Object)output, CoreMatchers.containsString("Clients:"));
        Assert.assertThat((Object)output, CoreMatchers.containsString("Zookeeper version:"));
        Assert.assertThat((Object)output, CoreMatchers.containsString("Node count:"));
    }
}

