/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.watch;

import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DumbWatcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchManagerFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchManagerOptimized;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class WatchManagerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchManagerTest.class);
    private static final String PATH_PREFIX = "/path";
    private ConcurrentHashMap<Integer, DumbWatcher> watchers;
    private Random r;
    private String className;

    public WatchManagerTest(String className) {
        this.className = className;
    }

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({WatchManager.class.getName()}, {WatchManagerOptimized.class.getName()});
    }

    @Before
    public void setUp() {
        ServerMetrics.getMetrics().resetAll();
        this.watchers = new ConcurrentHashMap();
        this.r = new Random(System.nanoTime());
    }

    public IWatchManager getWatchManager() throws IOException {
        System.setProperty("zookeeper.watchManagerName", this.className);
        return WatchManagerFactory.createWatchManager();
    }

    public DumbWatcher createOrGetWatcher(int watcherId) {
        if (!this.watchers.containsKey(watcherId)) {
            DumbWatcher watcher = new DumbWatcher(watcherId);
            this.watchers.putIfAbsent(watcherId, watcher);
        }
        return this.watchers.get(watcherId);
    }

    @Test(timeout=90000L)
    public void testAddAndTriggerWatcher() throws IOException {
        IWatchManager manager = this.getWatchManager();
        int paths = 1;
        int watchers = 10000;
        AtomicInteger watchTriggered = new AtomicInteger();
        ArrayList<WatcherTriggerWorker> triggerWorkers = new ArrayList<WatcherTriggerWorker>();
        for (int i = 0; i < 5; ++i) {
            WatcherTriggerWorker worker = new WatcherTriggerWorker(manager, paths, watchTriggered);
            triggerWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 100000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (WatcherTriggerWorker watcherTriggerWorker : triggerWorkers) {
            watcherTriggerWorker.shutdown();
        }
        Assert.assertTrue((watchesAdded.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)watchesAdded.get(), (long)watchTriggered.get());
    }

    @Test(timeout=90000L)
    public void testRemoveWatcherOnPath() throws IOException {
        IWatchManager manager = this.getWatchManager();
        int paths = 10;
        int watchers = 10000;
        AtomicInteger watchesRemoved = new AtomicInteger();
        ArrayList<RemoveWatcherWorker> removeWorkers = new ArrayList<RemoveWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            RemoveWatcherWorker worker = new RemoveWatcherWorker(manager, paths, watchers, watchesRemoved);
            removeWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 100000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (RemoveWatcherWorker removeWatcherWorker : removeWorkers) {
            removeWatcherWorker.shutdown();
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((watchesAdded.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((watchesRemoved.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)watchesAdded.get(), (long)(watchesRemoved.get() + manager.size()));
    }

    @Test(timeout=90000L)
    public void testDeadWatchers() throws IOException {
        System.setProperty("zookeeper.watcherCleanThreshold", "10");
        System.setProperty("zookeeper.watcherCleanIntervalInSeconds", "1");
        IWatchManager manager = this.getWatchManager();
        int paths = 1;
        int watchers = 100000;
        HashSet<Watcher> deadWatchers = new HashSet<Watcher>();
        ArrayList<CreateDeadWatchersWorker> deadWorkers = new ArrayList<CreateDeadWatchersWorker>();
        for (int i = 0; i < 5; ++i) {
            CreateDeadWatchersWorker worker = new CreateDeadWatchersWorker(manager, watchers, deadWatchers);
            deadWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 50000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i) {}
        }
        for (CreateDeadWatchersWorker createDeadWatchersWorker : deadWorkers) {
            createDeadWatchersWorker.shutdown();
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        WatchesReport existingWatchers = manager.getWatches();
        for (Watcher w : deadWatchers) {
            Assert.assertFalse((boolean)existingWatchers.hasPaths(((ServerCnxn)w).getSessionId()));
        }
    }

    private void checkMetrics(String metricName, long min, long max, double avg, long cnt, long sum) {
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)min, (Object)values.get("min_" + metricName));
        Assert.assertEquals((Object)max, (Object)values.get("max_" + metricName));
        Assert.assertEquals((double)avg, (double)((Double)values.get("avg_" + metricName)), (double)1.0E-6);
        Assert.assertEquals((Object)cnt, (Object)values.get("cnt_" + metricName));
        Assert.assertEquals((Object)sum, (Object)values.get("sum_" + metricName));
    }

    @Test
    public void testWatcherMetrics() throws IOException {
        IWatchManager manager = this.getWatchManager();
        ServerMetrics.getMetrics().resetAll();
        DumbWatcher watcher1 = new DumbWatcher(1L);
        DumbWatcher watcher2 = new DumbWatcher(2L);
        String path1 = "/path1";
        String path2 = "/path2";
        String path3 = "/path3";
        manager.addWatch("/path1", watcher1);
        manager.addWatch("/path1", watcher2);
        manager.addWatch("/path2", watcher1);
        manager.triggerWatch("/path3", Watcher.Event.EventType.NodeCreated);
        this.checkMetrics("node_created_watch_count", 0L, 0L, 0.0, 0L, 0L);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeCreated);
        this.checkMetrics("node_created_watch_count", 2L, 2L, 2.0, 1L, 2L);
        manager.triggerWatch("/path2", Watcher.Event.EventType.NodeCreated);
        this.checkMetrics("node_created_watch_count", 1L, 2L, 1.5, 2L, 3L);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeDataChanged);
        this.checkMetrics("node_changed_watch_count", 0L, 0L, 0.0, 0L, 0L);
        manager.addWatch("/path1", watcher1);
        manager.addWatch("/path1", watcher2);
        manager.addWatch("/path2", watcher1);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeDataChanged);
        this.checkMetrics("node_changed_watch_count", 2L, 2L, 2.0, 1L, 2L);
        manager.triggerWatch("/path2", Watcher.Event.EventType.NodeDeleted);
        this.checkMetrics("node_deleted_watch_count", 1L, 1L, 1.0, 1L, 1L);
        this.checkMetrics("node_created_watch_count", 1L, 2L, 1.5, 2L, 3L);
    }

    public class CreateDeadWatchersWorker
    extends Thread {
        private final IWatchManager manager;
        private final int watchers;
        private final Set<Watcher> removedWatchers;
        private volatile boolean stopped = false;

        public CreateDeadWatchersWorker(IWatchManager manager, int watchers, Set<Watcher> removedWatchers) {
            this.manager = manager;
            this.watchers = watchers;
            this.removedWatchers = removedWatchers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers));
                watcher.setStale();
                this.manager.removeWatcher(watcher);
                Set<Watcher> set = this.removedWatchers;
                synchronized (set) {
                    this.removedWatchers.add(watcher);
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class RemoveWatcherWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final int watchers;
        private final AtomicInteger watchesRemoved;
        private volatile boolean stopped = false;

        public RemoveWatcherWorker(IWatchManager manager, int paths, int watchers, AtomicInteger watchesRemoved) {
            this.manager = manager;
            this.paths = paths;
            this.watchers = watchers;
            this.watchesRemoved = watchesRemoved;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher;
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                if (this.manager.removeWatcher(path, watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers)))) {
                    this.watchesRemoved.addAndGet(1);
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class WatcherTriggerWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final AtomicInteger triggeredCount;
        private volatile boolean stopped = false;

        public WatcherTriggerWorker(IWatchManager manager, int paths, AtomicInteger triggeredCount) {
            this.manager = manager;
            this.paths = paths;
            this.triggeredCount = triggeredCount;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                WatcherOrBitSet s = this.manager.triggerWatch(path, Watcher.Event.EventType.NodeDeleted);
                if (s != null) {
                    this.triggeredCount.addAndGet(s.size());
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class AddWatcherWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final int watchers;
        private final AtomicInteger watchesAdded;
        private volatile boolean stopped = false;

        public AddWatcherWorker(IWatchManager manager, int paths, int watchers, AtomicInteger watchesAdded) {
            this.manager = manager;
            this.paths = paths;
            this.watchers = watchers;
            this.watchesAdded = watchesAdded;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher;
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                if (!this.manager.addWatch(path, watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers)))) continue;
                this.watchesAdded.addAndGet(1);
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }
}

