/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.cli;

import io.hops.hadoop.shaded.org.apache.commons.cli.CommandLine;
import io.hops.hadoop.shaded.org.apache.commons.cli.Options;
import io.hops.hadoop.shaded.org.apache.commons.cli.ParseException;
import io.hops.hadoop.shaded.org.apache.commons.cli.PosixParser;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;

public class RemoveWatchesCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public RemoveWatchesCommand() {
        super("removewatches", "path [-c|-d|-a] [-l]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliWrapperException, MalformedPathException {
        String path = this.args[1];
        Watcher.WatcherType wtype = Watcher.WatcherType.Any;
        if (this.cl.hasOption("c")) {
            wtype = Watcher.WatcherType.Children;
        } else if (this.cl.hasOption("d")) {
            wtype = Watcher.WatcherType.Data;
        } else if (this.cl.hasOption("a")) {
            wtype = Watcher.WatcherType.Any;
        }
        boolean local = this.cl.hasOption("l");
        try {
            this.zk.removeAllWatches(path, wtype, local);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return true;
    }

    static {
        options.addOption("c", false, "child watcher type");
        options.addOption("d", false, "data watcher type");
        options.addOption("a", false, "any watcher type");
        options.addOption("l", false, "remove locally when there is no server connection");
    }
}

