/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerConnection;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerXAResource;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class SQLServerXAConnection
extends SQLServerPooledConnection
implements XAConnection {
    private SQLServerXAResource XAResource;
    private SQLServerConnection physicalControlConnection;
    private Logger xaLogger = SQLServerXADataSource.xaLogger;

    SQLServerXAConnection(SQLServerDataSource ds, String user, String pwd) throws SQLException {
        super(ds, user, pwd);
        SQLServerConnection con = this.getPhysicalConnection();
        Properties controlConnectionProperties = (Properties)con.activeConnectionProperties.clone();
        controlConnectionProperties.setProperty(SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString(), "true");
        controlConnectionProperties.remove(SQLServerDriverStringProperty.SELECT_METHOD.toString());
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer("Creating an internal control connection for" + this.toString());
        }
        this.physicalControlConnection = new SQLServerConnection(this.toString());
        this.physicalControlConnection.connect(controlConnectionProperties, null);
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer("Created an internal control connection" + this.physicalControlConnection.toString() + " for " + this.toString() + " Physical connection:" + this.getPhysicalConnection().toString());
        }
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(ds.toString() + " user:" + user);
        }
    }

    @Override
    public synchronized XAResource getXAResource() throws SQLException {
        if (this.XAResource == null) {
            this.XAResource = new SQLServerXAResource(this.getPhysicalConnection(), this.physicalControlConnection, this.toString());
        }
        return this.XAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        SQLServerXAConnection sQLServerXAConnection = this;
        synchronized (sQLServerXAConnection) {
            if (this.XAResource != null) {
                this.XAResource.close();
                this.XAResource = null;
            }
            if (null != this.physicalControlConnection) {
                this.physicalControlConnection.close();
                this.physicalControlConnection = null;
            }
        }
        super.close();
    }
}

