/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.kson;

import io.hops.hadoop.shaded.org.nustaq.kson.KsonCharOutput;
import io.hops.hadoop.shaded.org.nustaq.kson.KsonSerializer;
import io.hops.hadoop.shaded.org.nustaq.kson.KsonTypeMapper;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;

public class JSonSerializer
extends KsonSerializer {
    protected String clazzAttributeName = "_type";
    protected boolean quoteKeyNames = true;
    private boolean tagTypes = true;

    public JSonSerializer(KsonCharOutput out, KsonTypeMapper mapper, FSTConfiguration conf) {
        super(out, mapper, conf);
    }

    public boolean isQuoteKeyNames() {
        return this.quoteKeyNames;
    }

    public void setQuoteKeyNames(boolean quoteKeyNames) {
        this.quoteKeyNames = quoteKeyNames;
    }

    public String getClazzAttributeName() {
        return this.clazzAttributeName;
    }

    public void setClazzAttributeName(String clazzAttributeName) {
        this.clazzAttributeName = clazzAttributeName;
    }

    @Override
    protected boolean shouldQuote(String string) {
        return true;
    }

    @Override
    protected void removeLastListSep() {
        this.out.back(2);
        this.out.writeChar('\n');
    }

    @Override
    protected void writeListEnd() {
        this.out.writeChar(']');
    }

    @Override
    protected void writeListStart() {
        this.out.writeString("[ ");
    }

    @Override
    protected void writeListSep() {
        if (this.out.lastChar() == '\n') {
            this.out.back(1);
            this.out.writeChar(',');
            this.out.writeChar('\n');
        } else {
            this.out.writeString(", ");
        }
    }

    @Override
    protected void writeClazzTag(Class expectedClass, Object o) {
        if (!this.tagTypes || expectedClass == o.getClass()) {
            this.out.writeString("{");
        } else {
            String stringForType = this.mapper.getStringForType(o.getClass());
            if (this.quoteKeyNames) {
                this.out.writeString("{ \"" + this.clazzAttributeName + "\": \"" + stringForType + "\" ,");
            } else {
                this.out.writeString("{ " + this.clazzAttributeName + ": \"" + stringForType + "\" ,");
            }
        }
    }

    @Override
    protected void writeKey(String name) {
        if (this.quoteKeyNames) {
            this.out.writeChar('\"');
            super.writeKey(name);
            this.out.writeChar('\"');
        } else {
            super.writeKey(name);
        }
    }

    public JSonSerializer noTypeTags() {
        this.tagTypes = false;
        return this;
    }
}

