/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics.extended;

import io.hops.hadoop.shaded.org.terracotta.statistics.Time;
import io.hops.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.archive.Timestamped;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.AbstractSampledStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.SamplingSupport;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.StatisticType;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SemiExpiringSampledStatistic<T extends Number>
extends AbstractSampledStatistic<T>
implements SamplingSupport {
    private boolean active = false;
    private long touchTimestamp = -1L;
    private volatile boolean alwaysOn = false;

    public SemiExpiringSampledStatistic(ValueStatistic<T> source, ScheduledExecutorService executor, int historySize, long historyTime, TimeUnit historyTimeUnit, StatisticType type) {
        super(source, executor, historySize, historyTime, historyTimeUnit, type);
    }

    @Override
    public List<Timestamped<T>> history() {
        this.touch();
        return super.history();
    }

    @Override
    public List<Timestamped<T>> history(long since) {
        this.touch();
        return super.history(since);
    }

    @Override
    public final synchronized boolean active() {
        return this.active;
    }

    protected final synchronized void touch() {
        this.touchTimestamp = Time.absoluteTime();
        this.start();
    }

    protected final synchronized void start() {
        if (!this.active) {
            this.startStatistic();
            this.startSampling();
            this.active = true;
        }
    }

    @Override
    public final synchronized boolean expire(long expiry) {
        if (this.alwaysOn) {
            return false;
        }
        if (this.touchTimestamp < expiry) {
            if (this.active) {
                this.stopSampling();
                this.stopStatistic();
                this.active = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAlwaysOn(boolean enable) {
        this.alwaysOn = enable;
        if (enable) {
            this.start();
        }
    }

    protected void stopStatistic() {
    }

    protected void startStatistic() {
    }
}

