/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import io.hops.hadoop.shaded.org.apache.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceMappings {
    private Map<String, AssignedResources> assignedResourcesMap = new HashMap<String, AssignedResources>();

    public List<Serializable> getAssignedResources(String resourceType) {
        AssignedResources ar = this.assignedResourcesMap.get(resourceType);
        if (null == ar) {
            return Collections.emptyList();
        }
        return ar.getAssignedResources();
    }

    public void addAssignedResources(String resourceType, AssignedResources assigned) {
        this.assignedResourcesMap.put(resourceType, assigned);
    }

    public static class AssignedResources
    implements Serializable {
        private static final long serialVersionUID = -1059491941955757926L;
        private List<Serializable> resources = Collections.emptyList();

        public List<Serializable> getAssignedResources() {
            return Collections.unmodifiableList(this.resources);
        }

        public void updateAssignedResources(List<Serializable> list) {
            this.resources = new ArrayList<Serializable>(list);
        }

        public static AssignedResources fromBytes(byte[] bytes) throws IOException {
            List resources;
            ObjectInputStream ois = null;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ois = new ObjectInputStream(bis);
                resources = (List)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ois);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)ois);
            AssignedResources ar = new AssignedResources();
            ar.updateAssignedResources(resources);
            return ar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toBytes() throws IOException {
            byte[] bytes;
            ObjectOutputStream oos = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this.resources);
                bytes = bos.toByteArray();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
            return bytes;
        }
    }
}

