/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.common.BCFKSFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.FileKeyStoreLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.JKSFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.PEMFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.PKCS12FileLoader;
import java.util.Objects;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

