/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.Time;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHammerTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientHammerTest.class);
    private static final long HAMMERTHREAD_LATENCY = 5L;

    @Test
    public void testHammerBasic() throws Throwable {
        this.runHammer(10, 1000);
    }

    public void runHammer(int threadCount, int childCount) throws Throwable {
        try {
            HammerThread[] threads = new HammerThread[threadCount];
            long start = Time.currentElapsedTime();
            for (int i = 0; i < threads.length; ++i) {
                TestableZooKeeper zk = this.createClient();
                String prefix = "/test-" + i;
                zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                prefix = prefix + "/";
                BasicHammerThread thread = new BasicHammerThread("BasicHammerThread-" + i, (ZooKeeper)zk, prefix, childCount);
                thread.start();
                threads[i] = thread;
            }
            this.verifyHammer(start, threads, childCount);
        }
        catch (Throwable t) {
            LOG.error("test failed", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHammerSuper() throws Throwable {
        try {
            int threadCount = 5;
            int childCount = 10;
            HammerThread[] threads = new HammerThread[5];
            long start = Time.currentElapsedTime();
            for (int i = 0; i < threads.length; ++i) {
                String prefix = "/test-" + i;
                try (TestableZooKeeper zk = this.createClient();){
                    zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                prefix = prefix + "/";
                SuperHammerThread thread = new SuperHammerThread("SuperHammerThread-" + i, this, prefix, 10);
                thread.start();
                threads[i] = thread;
            }
            this.verifyHammer(start, threads, 10);
        }
        catch (Throwable t) {
            LOG.error("test failed", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyHammer(long start, HammerThread[] threads, int childCount) throws IOException, InterruptedException, KeeperException {
        int n;
        LOG.info("Starting check for completed hammers");
        int workingCount = threads.length;
        for (int i = 0; i < 120; ++i) {
            Thread.sleep(10000L);
            HammerThread[] hammerThreadArray = threads;
            n = hammerThreadArray.length;
            for (int j = 0; j < n; ++j) {
                HammerThread h = hammerThreadArray[j];
                if (h.isAlive() && h.current != h.count) continue;
                --workingCount;
            }
            if (workingCount == 0) break;
            workingCount = threads.length;
        }
        if (workingCount > 0) {
            HammerThread[] i = threads;
            int n2 = i.length;
            for (n = 0; n < n2; ++n) {
                HammerThread h = i[n];
                LOG.warn("{} never finished creation, current:{}", (Object)h.getName(), (Object)h.current);
            }
        } else {
            LOG.info("Hammer threads completed creation operations");
        }
        for (HammerThread h : threads) {
            int safetyFactor = 3;
            ClientHammerTest.verifyThreadTerminated(h, (long)threads.length * (long)childCount * 5L * 3L);
        }
        LOG.info("{} Total time {}", (Object)new Date(), (Object)(Time.currentElapsedTime() - start));
        try (TestableZooKeeper zk = this.createClient();){
            int i;
            LOG.info("******************* Connected to ZooKeeper{}", (Object)new Date());
            for (i = 0; i < threads.length; ++i) {
                LOG.info("Doing thread: {} {}", (Object)i, (Object)new Date());
                List<String> children = zk.getChildren("/test-" + i, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
            }
            for (i = 0; i < threads.length; ++i) {
                List<String> children = zk.getChildren("/test-" + i, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
            }
        }
    }

    private static class SuperHammerThread
    extends HammerThread {
        private final ClientHammerTest parent;
        private final String prefix;

        SuperHammerThread(String name, ClientHammerTest parent, String prefix, int count) {
            super(name, count);
            this.parent = parent;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[256];
            try {
                while (this.current < this.count) {
                    TestableZooKeeper zk = this.parent.createClient();
                    try {
                        zk.create(this.prefix + this.current, b, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    finally {
                        try {
                            zk.close();
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Unexpected", (Throwable)e);
                        }
                    }
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("Client create operation failed", t);
            }
        }
    }

    private static class BasicHammerThread
    extends HammerThread {
        private final ZooKeeper zk;
        private final String prefix;

        BasicHammerThread(String name, ZooKeeper zk, String prefix, int count) {
            super(name, count);
            this.zk = zk;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            byte[] b = new byte[256];
            try {
                while (this.current < this.count) {
                    Thread.sleep(5L);
                    this.zk.create(this.prefix + this.current, b, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("Client create operation failed", t);
            }
            finally {
                try {
                    this.zk.close();
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    private static abstract class HammerThread
    extends Thread {
        protected final int count;
        protected volatile int current = 0;

        HammerThread(String name, int count) {
            super(name);
            this.count = count;
        }
    }
}

