/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EagerACLFilterTest
extends QuorumBase {
    protected boolean checkEnabled;
    protected QuorumPeer.ServerState serverState;
    protected final CountDownLatch callComplete = new CountDownLatch(1);
    protected boolean complete = false;
    protected static final String PARENT_PATH = "/foo";
    protected static final String CHILD_PATH = "/foo/bar";
    protected static final String AUTH_PROVIDER = "digest";
    protected static final byte[] AUTH = "hello".getBytes();
    protected static final byte[] AUTHB = "goodbye".getBytes();
    protected static final byte[] DATA = "Hint Water".getBytes();
    protected TestableZooKeeper zkClient;
    protected TestableZooKeeper zkClientB;
    protected QuorumPeer zkLeader;
    protected ZooKeeperServer connectedServer;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({QuorumPeer.ServerState.LEADING, true}, {QuorumPeer.ServerState.LEADING, false}, {QuorumPeer.ServerState.FOLLOWING, true}, {QuorumPeer.ServerState.FOLLOWING, false}, {QuorumPeer.ServerState.OBSERVING, true}, {QuorumPeer.ServerState.OBSERVING, false});
    }

    public EagerACLFilterTest(QuorumPeer.ServerState state, boolean checkEnabled) {
        this.serverState = state;
        this.checkEnabled = checkEnabled;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.ensureCheck(this.checkEnabled);
        ClientBase.CountdownWatcher clientWatch = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher clientWatchB = new ClientBase.CountdownWatcher();
        super.setUp(true);
        String hostPort = this.getPeersMatching(this.serverState).split(",")[0];
        int clientPort = Integer.parseInt(hostPort.split(":")[1]);
        this.zkLeader = this.getPeerList().get(this.getLeaderIndex());
        this.connectedServer = this.getPeerByClientPort(clientPort).getActiveServer();
        this.zkClient = this.createClient(clientWatch, hostPort);
        this.zkClientB = this.createClient(clientWatchB, hostPort);
        this.zkClient.addAuthInfo(AUTH_PROVIDER, AUTH);
        this.zkClientB.addAuthInfo(AUTH_PROVIDER, AUTHB);
        clientWatch.waitForConnected(CONNECTION_TIMEOUT);
        clientWatchB.waitForConnected(CONNECTION_TIMEOUT);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        if (this.zkClientB != null) {
            this.zkClientB.close();
        }
        super.tearDown();
    }

    private void ensureCheck(boolean enabled) {
        if (enabled) {
            System.setProperty("zookeeper.enableEagerACLCheck", "true");
        } else {
            System.clearProperty("zookeeper.enableEagerACLCheck");
        }
    }

    private void assertTransactionState(String condition, long lastxid) {
        String assertion = String.format("Server State: %s Check Enabled: %s %s", new Object[]{this.serverState, this.checkEnabled, condition});
        if (this.checkEnabled) {
            Assert.assertEquals((String)assertion, (long)lastxid, (long)this.zkLeader.getLastLoggedZxid());
        } else {
            Assert.assertNotSame((String)assertion, (Object)lastxid, (Object)this.zkLeader.getLastLoggedZxid());
        }
    }

    @Test
    public void testCreateOK() throws Exception {
        this.ensureCheck(true);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
    }

    @Test
    public void testCreate2OK() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
    }

    @Test
    public void testCreateFail() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("Transaction state on Leader after failed create", lastxid);
    }

    @Test
    public void testCreate2Fail() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("Transaction state on Leader after failed create2", lastxid);
    }

    @Test
    public void testDeleteOK() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.delete(PARENT_PATH, -1);
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
    }

    @Test
    public void testDeleteFail() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        this.zkClient.create(CHILD_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.delete(CHILD_PATH, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("Transaction state on Leader after failed delete", lastxid);
    }

    @Test
    public void testSetDataOK() throws Exception {
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setData(PARENT_PATH, DATA, -1);
    }

    @Test
    public void testSetDataFail() throws Exception {
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.setData(PARENT_PATH, DATA, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("Transaction state on Leader after failed setData", lastxid);
    }

    @Test
    public void testSetACLOK() throws Exception {
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
    }

    @Test
    public void testSetACLFail() throws Exception {
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("Transaction state on Leader after failed setACL", lastxid);
    }

    @Test
    public void testBadACL() throws Exception {
        ClientBase.CountdownWatcher cw = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = this.createClient(cw, this.getPeersMatching(this.serverState));
        cw.waitForConnected(CONNECTION_TIMEOUT);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            zk.create("/acltest", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have received an invalid acl error");
        }
        catch (KeeperException.InvalidACLException invalidACLException) {
            // empty catch block
        }
        Assert.assertEquals((String)"OutstandingRequests not decremented", (long)0L, (long)this.connectedServer.getInProcess());
        this.assertTransactionState("zxid after invalid ACL", lastxid);
    }
}

