/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigExceptionTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigExceptionTest.class);
    private static String authProvider = "zookeeper.DigestAuthenticationProvider.superDigest";
    private static String superDigest = "super:D/InIHSb7yEEbrWz8b9l71RjZJU=";
    private QuorumUtil qu;
    private ZooKeeperAdmin zkAdmin;

    @Before
    public void setup() throws InterruptedException {
        System.setProperty(authProvider, superDigest);
        QuorumPeerConfig.setReconfigEnabled(true);
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to start quorum servers.");
        }
        this.resetZKAdmin();
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(authProvider);
        try {
            if (this.qu != null) {
                this.qu.tearDown();
            }
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testReconfigDisabled() throws InterruptedException {
        QuorumPeerConfig.setReconfigEnabled(false);
        this.qu.shutdownAll();
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to start quorum servers.");
        }
        try {
            this.reconfigPort();
            Assert.fail((String)"Reconfig should be disabled.");
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.RECONFIGDISABLED ? 1 : 0) != 0);
        }
    }

    @Test(timeout=10000L)
    public void testReconfigFailWithoutAuth() throws InterruptedException {
        try {
            this.reconfigPort();
            Assert.fail((String)"Reconfig should fail without auth.");
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test(timeout=10000L)
    public void testReconfigEnabledWithSuperUser() throws InterruptedException {
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            Assert.assertTrue((boolean)this.reconfigPort());
        }
        catch (KeeperException e) {
            Assert.fail((String)("Reconfig should not fail, but failed with exception : " + e.getMessage()));
        }
    }

    @Test(timeout=10000L)
    public void testReconfigFailWithAuthWithNoACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            this.reconfigPort();
            Assert.fail((String)"Reconfig should fail without a valid ACL associated with user.");
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test(timeout=10000L)
    public void testReconfigEnabledWithAuthAndWrongACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            ArrayList<ACL> acls = new ArrayList<ACL>(Collections.singletonList(new ACL(1, new Id("digest", "user:tl+z3z0vO6PfPfEENfLF96E6pM0="))));
            this.zkAdmin.setACL("/zookeeper/config", acls, -1);
            this.resetZKAdmin();
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            this.reconfigPort();
            Assert.fail((String)"Reconfig should fail with an ACL that is read only!");
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test(timeout=10000L)
    public void testReconfigEnabledWithAuthAndACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            ArrayList<ACL> acls = new ArrayList<ACL>(Collections.singletonList(new ACL(2, new Id("digest", "user:tl+z3z0vO6PfPfEENfLF96E6pM0="))));
            this.zkAdmin.setACL("/zookeeper/config", acls, -1);
            this.resetZKAdmin();
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            Assert.assertTrue((boolean)this.reconfigPort());
        }
        catch (KeeperException e) {
            Assert.fail((String)("Reconfig should not fail, but failed with exception : " + e.getMessage()));
        }
    }

    private void resetZKAdmin() throws InterruptedException {
        String cnxString;
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        try {
            cnxString = "127.0.0.1:" + this.qu.getPeer((int)1).peer.getClientPort();
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
            this.zkAdmin = new ZooKeeperAdmin(cnxString, ClientBase.CONNECTION_TIMEOUT, watcher);
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to create ZooKeeperAdmin handle.");
            return;
        }
        try {
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)("ZooKeeper admin client can not connect to " + cnxString));
        }
    }

    private boolean reconfigPort() throws KeeperException, InterruptedException {
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderId = 1;
        while (this.qu.getPeer((int)leaderId).peer.leader == null) {
            ++leaderId;
        }
        int followerId = leaderId == 1 ? 2 : 1;
        joiningServers.add("server." + followerId + "=localhost:" + this.qu.getPeer((int)followerId).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)followerId).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + PortAssignment.unique());
        this.zkAdmin.reconfigure(joiningServers, null, null, -1L, new Stat());
        return true;
    }
}

