/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.streams;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import io.hops.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.impl.ReadyFutureImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.impl.SafeFutureImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.CompositeBuffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.streams.Input;
import io.hops.hadoop.shaded.org.glassfish.grizzly.utils.conditions.Condition;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BufferedInput
implements Input {
    protected final CompositeBuffer compositeBuffer;
    private volatile boolean isClosed;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected boolean isCompletionHandlerRegistered;
    protected Exception registrationStackTrace;
    protected Condition condition;
    protected CompletionHandler<Integer> completionHandler;
    protected FutureImpl<Integer> future;

    public BufferedInput() {
        this.compositeBuffer = CompositeBuffer.newBuffer();
    }

    protected abstract void onOpenInputSource() throws IOException;

    protected abstract void onCloseInputSource() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Buffer buffer) {
        if (buffer == null) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            if (this.isClosed) {
                buffer.dispose();
            } else {
                int addSize = buffer.remaining();
                if (addSize > 0) {
                    this.compositeBuffer.append(buffer);
                }
                this.notifyUpdate();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Buffer buffer) {
        if (buffer == null) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            if (this.isClosed) {
                buffer.dispose();
            } else {
                int addSize = buffer.remaining();
                if (addSize > 0) {
                    this.compositeBuffer.prepend(buffer);
                }
                this.notifyUpdate();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    @Override
    public byte read() throws IOException {
        byte result = this.compositeBuffer.get();
        this.compositeBuffer.shrink();
        return result;
    }

    @Override
    public void skip(int length) {
        if (length > this.size()) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        this.compositeBuffer.position(this.compositeBuffer.position() + length);
        this.compositeBuffer.shrink();
    }

    @Override
    public final boolean isBuffered() {
        return true;
    }

    @Override
    public Buffer getBuffer() {
        return this.compositeBuffer;
    }

    @Override
    public Buffer takeBuffer() {
        Buffer duplicate = this.compositeBuffer.duplicate();
        this.compositeBuffer.removeAll();
        return duplicate;
    }

    @Override
    public int size() {
        return this.compositeBuffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.compositeBuffer.dispose();
                CompletionHandler<Integer> localCompletionHandler = this.completionHandler;
                if (localCompletionHandler != null) {
                    this.completionHandler = null;
                    this.isCompletionHandlerRegistered = false;
                    this.notifyFailure(localCompletionHandler, new EOFException("Input is closed"));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public GrizzlyFuture<Integer> notifyCondition(Condition condition, CompletionHandler<Integer> completionHandler) {
        this.lock.writeLock().lock();
        try {
            if (!this.isCompletionHandlerRegistered) {
                if (condition.check()) {
                    this.notifyCompleted(completionHandler);
                    ReadyFutureImpl<Integer> readyFutureImpl = ReadyFutureImpl.create(this.compositeBuffer.remaining());
                    return readyFutureImpl;
                }
                this.registrationStackTrace = new Exception();
                this.isCompletionHandlerRegistered = true;
                this.completionHandler = completionHandler;
                SafeFutureImpl<Integer> localFuture = SafeFutureImpl.create();
                this.future = localFuture;
                this.condition = condition;
                try {
                    this.onOpenInputSource();
                }
                catch (IOException e) {
                    this.notifyFailure(completionHandler, e);
                    ReadyFutureImpl<Integer> readyFutureImpl = ReadyFutureImpl.create(e);
                    this.lock.writeLock().unlock();
                    return readyFutureImpl;
                }
                SafeFutureImpl<Integer> safeFutureImpl = localFuture;
                return safeFutureImpl;
            }
            throw new IllegalStateException("Only one notificator could be registered. Previous registration came from: ", this.registrationStackTrace);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void notifyUpdate() {
        if (this.condition != null && this.condition.check()) {
            this.condition = null;
            CompletionHandler<Integer> localCompletionHandler = this.completionHandler;
            this.completionHandler = null;
            FutureImpl<Integer> localFuture = this.future;
            this.future = null;
            this.isCompletionHandlerRegistered = false;
            try {
                this.onCloseInputSource();
                this.notifyCompleted(localCompletionHandler);
                localFuture.result(this.compositeBuffer.remaining());
            }
            catch (IOException e) {
                this.notifyFailure(localCompletionHandler, e);
                localFuture.failure(e);
            }
        }
    }

    protected void notifyCompleted(CompletionHandler<Integer> completionHandler) {
        if (completionHandler != null) {
            completionHandler.completed(this.compositeBuffer.remaining());
        }
    }

    protected void notifyFailure(CompletionHandler<Integer> completionHandler, Throwable failure) {
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }
}

